/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers.engine.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.gcube.data.transfer.model.TransferTicket;
import org.gcube.data.transfer.service.transfers.engine.TicketManager;
import org.gcube.data.transfer.service.transfers.engine.faults.TicketNotFoundException;
import org.gcube.data.transfer.service.transfers.engine.impl.TransferTicketManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TransferTicketManagerImpl
implements TicketManager {
    private static final Logger log = LoggerFactory.getLogger(TransferTicketManagerImpl.class);
    private static ConcurrentHashMap<String, TTLContainer> theMap = new ConcurrentHashMap();
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    static {
        scheduler.scheduleAtFixedRate((Runnable)new /* Unavailable Anonymous Inner Class!! */, 30L, 30L, TimeUnit.MINUTES);
    }

    public boolean insertUpdate(TransferTicket toInsert) {
        return theMap.put(toInsert.getId(), new TTLContainer(this, toInsert)) != null;
    }

    public TransferTicket get(String ticketId) throws TicketNotFoundException {
        if (theMap.containsKey(ticketId)) {
            return ((TTLContainer)theMap.get(ticketId)).getTicket();
        }
        throw new TicketNotFoundException(String.format("Ticket [%s] not found. Request is probably served and outdated", ticketId));
    }

    static /* synthetic */ Logger access$0() {
        return log;
    }

    static /* synthetic */ ConcurrentHashMap access$1() {
        return theMap;
    }
}

