/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers.engine.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.service.transfers.engine.RequestManager;
import org.gcube.data.transfer.service.transfers.engine.TicketManager;
import org.gcube.data.transfer.service.transfers.engine.impl.RequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RequestManagerImpl
implements RequestManager {
    private static final Logger log = LoggerFactory.getLogger(RequestManagerImpl.class);
    ExecutorService executor;
    private TicketManager manager;

    @Inject
    public RequestManagerImpl(TicketManager manager) {
        this.manager = manager;
        this.executor = Executors.newCachedThreadPool();
    }

    public boolean put(TransferRequest request) {
        try {
            this.executor.execute((Runnable)new RequestHandler(request, this.manager));
            return true;
        }
        catch (Exception e) {
            log.debug("Unexpected Error while creating handler", (Throwable)e);
            return false;
        }
    }
}

