/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.transfer.model.PluginDescription;
import org.gcube.data.transfer.model.options.DirectTransferOptions;
import org.gcube.data.transfer.model.options.HttpDownloadOptions;
import org.gcube.data.transfer.model.options.TransferOptions;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class TransferCapabilities {
    @XmlID
    private String nodeId;
    @XmlElement
    private String hostName;
    @XmlElement
    private Integer port;
    @XmlElementWrapper
    @XmlElementRefs(value={@XmlElementRef(type=DirectTransferOptions.class), @XmlElementRef(type=HttpDownloadOptions.class)})
    @JsonProperty(value="availableMeans")
    private Set<TransferOptions> availableMeans;
    @XmlElementWrapper
    private Set<PluginDescription> availablePlugins;
    @XmlElementWrapper
    private Set<String> availablePersistenceIds;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.availableMeans != null) {
            for (TransferOptions transferOptions : this.availableMeans) {
                result = 31 * result + (transferOptions == null ? 0 : transferOptions.hashCode());
            }
        }
        if (this.availablePlugins != null) {
            for (PluginDescription pluginDescription : this.availablePlugins) {
                result = 31 * result + (pluginDescription == null ? 0 : pluginDescription.hashCode());
            }
        }
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        result = 31 * result + (this.hostName == null ? 0 : this.hostName.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransferCapabilities other = (TransferCapabilities)obj;
        if (this.availableMeans == null || this.availableMeans.isEmpty()) {
            if (other.availableMeans != null && !other.availableMeans.isEmpty()) {
                return false;
            }
            if (this.availableMeans != null && !this.availableMeans.isEmpty()) {
                if (other.availableMeans == null || other.availableMeans.isEmpty()) {
                    return false;
                }
                if (this.availableMeans.size() != other.availableMeans.size()) {
                    return false;
                }
                for (TransferOptions transferOptions : this.availableMeans) {
                    if (other.availableMeans.contains(transferOptions)) continue;
                    return false;
                }
            }
        }
        if (this.availablePlugins == null || this.availablePlugins.isEmpty()) {
            if (other.availablePlugins != null && !other.availablePlugins.isEmpty()) {
                return false;
            }
            if (this.availablePlugins != null && !this.availablePlugins.isEmpty()) {
                if (other.availablePlugins == null || other.availablePlugins.isEmpty()) {
                    return false;
                }
                if (this.availablePlugins.size() != other.availablePlugins.size()) {
                    return false;
                }
                for (PluginDescription pluginDescription : this.availablePlugins) {
                    if (other.availablePlugins.contains(pluginDescription)) continue;
                    return false;
                }
            }
        }
        if (this.availablePersistenceIds == null || this.availablePersistenceIds.isEmpty()) {
            if (other.availablePersistenceIds != null && !other.availablePersistenceIds.isEmpty()) {
                return false;
            }
            if (this.availablePersistenceIds != null && !this.availablePersistenceIds.isEmpty()) {
                if (other.availablePersistenceIds == null || other.availablePersistenceIds.isEmpty()) {
                    return false;
                }
                if (this.availablePersistenceIds.size() != other.availablePersistenceIds.size()) {
                    return false;
                }
                for (String string : this.availablePersistenceIds) {
                    if (other.availablePersistenceIds.contains(string)) continue;
                    return false;
                }
            }
        }
        if (this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId)) {
            return false;
        }
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        return !(this.port == null ? other.port != null : !this.port.equals(other.port));
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Integer getPort() {
        return this.port;
    }

    public Set<TransferOptions> getAvailableMeans() {
        return this.availableMeans;
    }

    public Set<PluginDescription> getAvailablePlugins() {
        return this.availablePlugins;
    }

    public Set<String> getAvailablePersistenceIds() {
        return this.availablePersistenceIds;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setAvailableMeans(Set<TransferOptions> availableMeans) {
        this.availableMeans = availableMeans;
    }

    public void setAvailablePlugins(Set<PluginDescription> availablePlugins) {
        this.availablePlugins = availablePlugins;
    }

    public void setAvailablePersistenceIds(Set<String> availablePersistenceIds) {
        this.availablePersistenceIds = availablePersistenceIds;
    }

    public String toString() {
        return "TransferCapabilities(nodeId=" + this.getNodeId() + ", hostName=" + this.getHostName() + ", port=" + this.getPort() + ", availableMeans=" + this.getAvailableMeans() + ", availablePlugins=" + this.getAvailablePlugins() + ", availablePersistenceIds=" + this.getAvailablePersistenceIds() + ")";
    }

    public TransferCapabilities() {
    }

    @ConstructorProperties(value={"nodeId", "hostName", "port", "availableMeans", "availablePlugins", "availablePersistenceIds"})
    public TransferCapabilities(String nodeId, String hostName, Integer port, Set<TransferOptions> availableMeans, Set<PluginDescription> availablePlugins, Set<String> availablePersistenceIds) {
        this.nodeId = nodeId;
        this.hostName = hostName;
        this.port = port;
        this.availableMeans = availableMeans;
        this.availablePlugins = availablePlugins;
        this.availablePersistenceIds = availablePersistenceIds;
    }
}

