/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.model;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.model.settings.DirectTransferSettings;
import org.gcube.data.transfer.model.settings.HttpDownloadSettings;
import org.gcube.data.transfer.model.settings.TransferSettings;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class TransferRequest {
    @XmlID
    private String id;
    @XmlElementRefs(value={@XmlElementRef(type=DirectTransferSettings.class), @XmlElementRef(type=HttpDownloadSettings.class)})
    private TransferSettings settings;
    @XmlElement
    private Destination destinationSettings;
    @XmlElementWrapper
    private Set<PluginInvocation> pluginInvocations;

    public TransferRequest(String id, TransferSettings settings, Destination destinationSettings) {
        this.id = id;
        this.settings = settings;
        this.destinationSettings = destinationSettings;
        this.pluginInvocations = Collections.emptySet();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransferRequest other = (TransferRequest)obj;
        if (this.destinationSettings == null ? other.destinationSettings != null : !this.destinationSettings.equals(other.destinationSettings)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.pluginInvocations == null || this.pluginInvocations.isEmpty()) {
            if (other.pluginInvocations != null && !other.pluginInvocations.isEmpty()) {
                return false;
            }
            if (this.pluginInvocations != null && !this.pluginInvocations.isEmpty()) {
                if (other.pluginInvocations == null || other.pluginInvocations.isEmpty()) {
                    return false;
                }
                if (this.pluginInvocations.size() != other.pluginInvocations.size()) {
                    return false;
                }
                for (PluginInvocation opt : this.pluginInvocations) {
                    if (other.pluginInvocations.contains(opt)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destinationSettings == null ? 0 : this.destinationSettings.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        if (this.pluginInvocations != null) {
            for (PluginInvocation opt : this.pluginInvocations) {
                result = 31 * result + (opt == null ? 0 : opt.hashCode());
            }
        }
        result = 31 * result + (this.settings == null ? 0 : this.settings.hashCode());
        return result;
    }

    public String getId() {
        return this.id;
    }

    public TransferSettings getSettings() {
        return this.settings;
    }

    public Destination getDestinationSettings() {
        return this.destinationSettings;
    }

    public Set<PluginInvocation> getPluginInvocations() {
        return this.pluginInvocations;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSettings(TransferSettings settings) {
        this.settings = settings;
    }

    public void setDestinationSettings(Destination destinationSettings) {
        this.destinationSettings = destinationSettings;
    }

    public void setPluginInvocations(Set<PluginInvocation> pluginInvocations) {
        this.pluginInvocations = pluginInvocations;
    }

    public String toString() {
        return "TransferRequest(id=" + this.getId() + ", settings=" + this.getSettings() + ", destinationSettings=" + this.getDestinationSettings() + ", pluginInvocations=" + this.getPluginInvocations() + ")";
    }

    public TransferRequest() {
    }

    @ConstructorProperties(value={"id", "settings", "destinationSettings", "pluginInvocations"})
    public TransferRequest(String id, TransferSettings settings, Destination destinationSettings, Set<PluginInvocation> pluginInvocations) {
        this.id = id;
        this.settings = settings;
        this.destinationSettings = destinationSettings;
        this.pluginInvocations = pluginInvocations;
    }
}

