/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.library.caches;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gcube.data.transfer.library.caches.TTLContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TTLCache<T> {
    private static final Logger log = LoggerFactory.getLogger(TTLCache.class);
    private final Object $lock = new Object[0];
    private static final HashSet<TTLCache<?>> createdMaps = new HashSet();
    private ConcurrentHashMap<String, TTLContainer<T>> theMap = new ConcurrentHashMap();
    private Long cacheKeepAliveTime;
    private Long objectTTL;
    private String cacheName;

    protected TTLCache(Long cacheKeepAliveTime, Long objectTTL, String cacheName) {
        this.cacheKeepAliveTime = cacheKeepAliveTime;
        this.objectTTL = objectTTL;
        this.cacheName = cacheName;
        createdMaps.add(this);
        log.debug("Created Cache " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getObject(String id) throws Exception {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.theMap.contains(id) || System.currentTimeMillis() - this.theMap.get(id).getCreationTime() > this.objectTTL) {
                this.theMap.put(id, new TTLContainer<T>(this.getNew(id)));
            }
            return this.theMap.get(id).getTheObject();
        }
    }

    private int purgeItems() {
        log.debug(this.cacheName + " Purging objects, keep alive time is " + this.cacheKeepAliveTime);
        int totalCount = this.theMap.size();
        int removed = 0;
        for (Map.Entry<String, TTLContainer<T>> entry : this.theMap.entrySet()) {
            if (System.currentTimeMillis() - entry.getValue().getLastUsageTime() <= this.cacheKeepAliveTime) continue;
            this.theMap.remove(entry.getKey());
            ++removed;
        }
        log.debug(this.cacheName + " Removed " + removed + " out of " + totalCount);
        return removed;
    }

    protected abstract T getNew(String var1) throws Exception;

    public String toString() {
        return "TTLCache(theMap=" + this.theMap + ", cacheKeepAliveTime=" + this.cacheKeepAliveTime + ", objectTTL=" + this.objectTTL + ", cacheName=" + this.cacheName + ")";
    }
}

