/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.library;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.gcube.data.transfer.library.TransferResult;
import org.gcube.data.transfer.library.faults.DestinationNotSetException;
import org.gcube.data.transfer.library.faults.FailedTransferException;
import org.gcube.data.transfer.library.faults.HostingNodeNotFoundException;
import org.gcube.data.transfer.library.faults.InitializationException;
import org.gcube.data.transfer.library.faults.InvalidDestinationException;
import org.gcube.data.transfer.library.faults.InvalidSourceException;
import org.gcube.data.transfer.library.faults.ServiceNotFoundException;
import org.gcube.data.transfer.library.faults.SourceNotSetException;
import org.gcube.data.transfer.library.faults.UnreachableNodeException;
import org.gcube.data.transfer.library.transferers.Transferer;
import org.gcube.data.transfer.library.transferers.TransfererBuilder;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.model.TransferCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTransferClient {
    private static final Logger log = LoggerFactory.getLogger(DataTransferClient.class);
    private Transferer transferer = null;

    private DataTransferClient(Transferer transferer) {
        this.transferer = transferer;
    }

    public static DataTransferClient getInstanceByEndpoint(String endpoint) throws UnreachableNodeException, ServiceNotFoundException {
        log.debug("Getting transferer for endpoint : " + endpoint);
        return new DataTransferClient(TransfererBuilder.getTransfererByHost(endpoint));
    }

    public static DataTransferClient getInstanceByNodeId(String id) throws HostingNodeNotFoundException, UnreachableNodeException, ServiceNotFoundException {
        log.debug("Getting transferer for nodeId : " + id);
        return new DataTransferClient(TransfererBuilder.getTransfererByhostingNodeId(id));
    }

    public TransferCapabilities getDestinationCapabilities() throws InitializationException {
        return this.transferer.getDestinationCapabilities();
    }

    public TransferResult localFile(String path, Destination dest) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        return this.localFile(path, dest, Collections.emptySet());
    }

    public TransferResult localFile(File file, Destination dest) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        return this.localFile(file, dest, Collections.emptySet());
    }

    public TransferResult httpSource(String url, Destination dest) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        return this.httpSource(url, dest, Collections.emptySet());
    }

    public TransferResult httpSource(URL url, Destination dest) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        return this.httpSource(url, dest, Collections.emptySet());
    }

    public TransferResult storageId(String id, Destination dest) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        return this.storageId(id, dest, Collections.emptySet());
    }

    public TransferResult localFile(String path, Destination dest, PluginInvocation pluginInvocation) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        return this.localFile(path, dest, Collections.singleton(pluginInvocation));
    }

    public TransferResult localFile(File file, Destination dest, PluginInvocation pluginInvocation) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        return this.localFile(file, dest, Collections.singleton(pluginInvocation));
    }

    public TransferResult httpSource(String url, Destination dest, PluginInvocation pluginInvocation) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        return this.httpSource(url, dest, Collections.singleton(pluginInvocation));
    }

    public TransferResult httpSource(URL url, Destination dest, PluginInvocation pluginInvocation) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        return this.httpSource(url, dest, Collections.singleton(pluginInvocation));
    }

    public TransferResult storageId(String id, Destination dest, PluginInvocation pluginInvocation) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        return this.storageId(id, dest, Collections.singleton(pluginInvocation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferResult localFile(String path, Destination dest, Set<PluginInvocation> pluginInvocations) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        Transferer transferer = this.transferer;
        synchronized (transferer) {
            if (this.transferer == null) {
                throw new RuntimeException("Transferer not set, please set destination before trying to transfer");
            }
            log.debug("Sending local file {} to {} : {} - {}", new Object[]{path, this.transferer.getDestinationCapabilities().getHostName(), dest, pluginInvocations});
            this.transferer.localFile(path);
            return this.doTheTransfer(dest, pluginInvocations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferResult localFile(File file, Destination dest, Set<PluginInvocation> pluginInvocations) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        Transferer transferer = this.transferer;
        synchronized (transferer) {
            if (this.transferer == null) {
                throw new RuntimeException("Transferer not set, please set destination before trying to transfer");
            }
            log.debug("Sending local file {} to {} : {} - {}", new Object[]{file.getAbsolutePath(), this.transferer.getDestinationCapabilities().getHostName(), dest, pluginInvocations});
            this.transferer.localFile(file);
            return this.doTheTransfer(dest, pluginInvocations);
        }
    }

    public TransferResult httpSource(String url, Destination dest, Set<PluginInvocation> pluginInvocations) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        Transferer transferer = this.transferer;
        synchronized (transferer) {
            if (this.transferer == null) {
                throw new RuntimeException("Transferer not set, please set destination before trying to transfer");
            }
            log.debug("Passed url string : " + url);
            try {
                return this.httpSource(new URL(url), dest, pluginInvocations);
            }
            catch (MalformedURLException e) {
                throw new InvalidSourceException("Invalid url : " + url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferResult httpSource(URL url, Destination dest, Set<PluginInvocation> pluginInvocations) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        Transferer transferer = this.transferer;
        synchronized (transferer) {
            if (this.transferer == null) {
                throw new RuntimeException("Transferer not set, please set destination before trying to transfer");
            }
            log.debug("Sending from url {} to {} : {} - {}", new Object[]{url, this.transferer.getDestinationCapabilities().getHostName(), dest, pluginInvocations});
            this.transferer.fromURL(url);
            return this.doTheTransfer(dest, pluginInvocations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferResult storageId(String id, Destination dest, Set<PluginInvocation> pluginInvocations) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        Transferer transferer = this.transferer;
        synchronized (transferer) {
            if (this.transferer == null) {
                throw new RuntimeException("Transferer not set, please set destination before trying to transfer");
            }
            log.debug("Sending from storage id {} to {} : {} - {}", new Object[]{id, this.transferer.getDestinationCapabilities().getHostName(), dest, pluginInvocations});
            this.transferer.storageFileId(id);
            return this.doTheTransfer(dest, pluginInvocations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransferResult doTheTransfer(Destination dest, Set<PluginInvocation> pluginInvocations) throws SourceNotSetException, InvalidSourceException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        try {
            this.transferer.setDestination(dest);
            this.transferer.setInvocations(pluginInvocations);
            TransferResult transferResult = this.transferer.transfer();
            return transferResult;
        }
        finally {
            this.transferer.reset();
        }
    }
}

