/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.library.transferers;

import java.net.URL;
import java.util.List;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.data.transfer.library.client.Client;
import org.gcube.data.transfer.library.faults.HostingNodeNotFoundException;
import org.gcube.data.transfer.library.faults.ServiceNotFoundException;
import org.gcube.data.transfer.library.faults.UnreachableNodeException;
import org.gcube.data.transfer.library.transferers.HTTPTransferer;
import org.gcube.data.transfer.library.transferers.Transferer;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransfererBuilder {
    private static final Logger log = LoggerFactory.getLogger(TransfererBuilder.class);
    private static final int timeout = 10000;

    public static Transferer getTransfererByHost(String endpoint) throws UnreachableNodeException, ServiceNotFoundException {
        log.debug("Get transferer by Host " + endpoint);
        try {
            URL url = new URL(endpoint);
            String baseUrl = String.valueOf(url.getProtocol()) + "://" + url.getHost() + ":" + url.getPort();
            return new HTTPTransferer(new Client(baseUrl));
        }
        catch (Exception e) {
            throw new ServiceNotFoundException(e);
        }
    }

    public static Transferer getTransfererByhostingNodeId(String hostId) throws HostingNodeNotFoundException, UnreachableNodeException, ServiceNotFoundException {
        String hostname = TransfererBuilder.retrieveHostnameByNodeId(hostId);
        return TransfererBuilder.getTransfererByHost(hostname);
    }

    private static String retrieveHostnameByNodeId(String nodeId) throws HostingNodeNotFoundException {
        XQuery query = ICFactory.queryFor(HostingNode.class);
        query.addCondition("$resource/ID/text() eq '" + nodeId + "'");
        List found = ICFactory.clientFor(HostingNode.class).submit((Query)query);
        if (found.isEmpty()) {
            throw new HostingNodeNotFoundException("No Hosting node with the id " + nodeId);
        }
        return "http://" + ((HostingNode)found.get(0)).profile().description().name();
    }
}

