/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.common.utils;

import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.core.faults.ExceptionProxy;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.streams.Stream;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.Bindings;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.Patterns;
import org.gcube.data.trees.streams.TreeStreams;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.common.grs.FileOutcomeRecord;
import org.gcube.datatransfer.common.outcome.FileTransferOutcome;
import org.gcube.datatransfer.common.outcome.TransferOutcome;
import org.gcube.datatransfer.common.outcome.TreeTransferOutcome;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Utils {
    public static GCUBELog logger = new GCUBELog(Utils.class);
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public static Pattern getPattern(Types.AnyHolder h) throws Exception {
        return h == null ? null : (Pattern)Patterns.getUnMarshaller().unmarshal((org.w3c.dom.Node)h.element[0]);
    }

    public static Types.AnyHolder toHolder(Pattern p) throws Exception {
        if (p == null) {
            return null;
        }
        Document filterNode = factory.newDocumentBuilder().newDocument();
        Patterns.getMarshaller().marshal((Object)p, (org.w3c.dom.Node)filterNode);
        return Utils.toHolder(filterNode.getDocumentElement());
    }

    public static Types.AnyHolder toHolder(Element e) {
        if (e == null) {
            return null;
        }
        Types.AnyHolder holder = new Types.AnyHolder();
        holder.element = new Element[]{e};
        return holder;
    }

    public static Types.AnyHolder toHolder(Node n) throws Exception {
        return n == null ? null : Utils.toHolder(Bindings.nodeToElement((Node)n, (QName[])new QName[0]));
    }

    public static void copyfile(File f1, File f2) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(f1);
        FileOutputStream out = new FileOutputStream(f2);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static <E extends GCUBEFault> E newFault(E fault, Throwable cause) {
        fault.setFaultMessage(cause.getMessage());
        fault.removeFaultDetail(new QName("http://xml.apache.org/axis/", "stackTrace"));
        StringWriter w = new StringWriter();
        cause.printStackTrace(new PrintWriter(w));
        fault.addFaultDetailString(w.toString());
        try {
            fault.addFaultDetail(ExceptionProxy.newInstance((Throwable)cause).toElement());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fault;
    }

    public static void copyfileToFolder(File file, File outFolder, String fileName) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(file);
        FileOutputStream out = new FileOutputStream(outFolder.getAbsolutePath() + File.separator + fileName);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static <T extends TransferOutcome> ArrayList<T> getFileOutcomes(String outcomeRSURI) throws Exception {
        logger.debug((Object)("Outcome grs URI" + outcomeRSURI));
        ForwardReader reader = new ForwardReader(new URI(outcomeRSURI));
        ArrayList<FileTransferOutcome> outcomes = new ArrayList<FileTransferOutcome>();
        for (int i = 0; i < reader.getCapacity(); ++i) {
            GenericRecord rec = null;
            while ((rec = (GenericRecord)reader.get()) == null) {
                Thread.sleep(100L);
            }
            StringField sourceURLField = (StringField)rec.getField("SourceURLField");
            logger.trace((Object)("FileName :" + sourceURLField.getPayload()));
            StringField destURLField = (StringField)rec.getField("DestURLField");
            logger.trace((Object)("dest :" + destURLField.getPayload()));
            StringField outcomeField = (StringField)rec.getField("OutcomeField");
            logger.trace((Object)("Outcome :" + outcomeField.getPayload()));
            StringField timeField = (StringField)rec.getField("TransferTimeField");
            logger.trace((Object)("Transfer Time: " + timeField.getPayload()));
            StringField bytesField = (StringField)rec.getField("TransferredBytesField");
            logger.trace((Object)("Transferred Bytes: " + bytesField.getPayload()));
            StringField sizeField = (StringField)rec.getField("SizeField");
            logger.trace((Object)("Size: " + sizeField.getPayload()));
            StringField exceptionField = (StringField)rec.getField("ExceptionField");
            logger.trace((Object)("Exception: " + exceptionField.getPayload()));
            FileTransferOutcome outcome = new FileTransferOutcome(sourceURLField.getPayload());
            outcome.setException(exceptionField.getPayload());
            outcome.setDest(destURLField.getPayload());
            outcome.setTransferTime(Long.valueOf(timeField.getPayload()));
            outcome.setTransferredBytes(Long.valueOf(bytesField.getPayload()));
            outcome.setTotal_size(Long.valueOf(sizeField.getPayload()));
            outcomes.add(outcome);
        }
        try {
            reader.close();
            logger.debug((Object)"reader closed");
        }
        catch (GRS2ReaderException e1) {
            e1.printStackTrace();
        }
        return outcomes;
    }

    public static <T extends TransferOutcome> ArrayList<T> getTreeOutcomes(String outcomeRSURI) throws Exception {
        logger.debug((Object)outcomeRSURI);
        if (outcomeRSURI == null || outcomeRSURI.compareTo("") == 0) {
            throw new Exception("gRS2 endpoint is null");
        }
        Stream stream = TreeStreams.treesIn((URI)URI.create(outcomeRSURI));
        ArrayList<TreeTransferOutcome> outcomes = new ArrayList<TreeTransferOutcome>();
        while (stream.hasNext()) {
            Tree tree = null;
            TreeTransferOutcome outcome = new TreeTransferOutcome();
            try {
                tree = (Tree)stream.next();
                outcome.setTree(tree);
                outcome.setException(FileOutcomeRecord.Outcome.N_A.name());
            }
            catch (Exception e) {
                outcome.setException(FileOutcomeRecord.Outcome.ERROR.name());
            }
            outcomes.add(outcome);
        }
        stream.close();
        return outcomes;
    }
}

