/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.common.messaging.producer;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.datatransfer.common.messaging.ConnectionsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Producer
implements Runnable {
    private static int ackMode;
    private static boolean transacted;
    private static Producer singleton;
    private String selectorBase = "MessageType";
    private static Integer MAX_MONITORING_QUEUE_SIZE;
    private static Integer MAX_ACCOUNTING_QUEUE_SIZE;
    private static ConcurrentLinkedQueue<GCUBEMessage> messageForQueue;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    private Producer() {
    }

    public void sendMessageToQueue(GCUBEMessage message) {
        QueueConnection connection = ConnectionsManager.getQueueConnection(GCUBEScope.getScope((String)message.getScope()));
        if (connection != null) {
            try {
                QueueSession session = connection.createQueueSession(transacted, ackMode);
                Queue queue = session.createQueue(message.getTopic());
                QueueSender sender = session.createSender(queue);
                sender.setDeliveryMode(2);
                ObjectMessage objMsg = session.createObjectMessage();
                objMsg.setObject((Serializable)message);
                objMsg.setJMSMessageID(this.createRandomString());
                sender.send((Message)objMsg);
                this.logger.debug("Message " + message.toString() + " SENT");
                return;
            }
            catch (JMSException e) {
                this.logger.error("Exception sending message to the Broker", (Throwable)e);
                this.enqueueMessageForQueue(message);
            }
            catch (Exception e) {
                this.logger.error("Exception sending message to the Broker", (Throwable)e);
                this.enqueueMessageForQueue(message);
            }
        } else {
            ConnectionsManager.reloadConnection(GCUBEScope.getScope((String)message.getScope()));
        }
    }

    private String createRandomString() {
        Random random = new Random(System.currentTimeMillis());
        long randomLong = random.nextLong();
        return Long.toHexString(randomLong);
    }

    public static Producer getSingleton() {
        return singleton;
    }

    public void setSingleton(Producer singleton) {
        Producer.singleton = singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueMessageForQueue(GCUBEMessage message) {
        try {
            ConcurrentLinkedQueue<GCUBEMessage> concurrentLinkedQueue = messageForQueue;
            synchronized (concurrentLinkedQueue) {
                if (messageForQueue.size() >= MAX_ACCOUNTING_QUEUE_SIZE) {
                    this.logger.error("Reached Maximum queue size, message discarded");
                    this.logger.error(message.toString());
                } else {
                    messageForQueue.add(message);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error enqueuing Message : " + message.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int sizeQueue = 0;
        boolean sizeTopic = false;
        while (true) {
            ConcurrentLinkedQueue<GCUBEMessage> concurrentLinkedQueue = messageForQueue;
            synchronized (concurrentLinkedQueue) {
                sizeQueue = messageForQueue.size();
            }
            if (sizeQueue == 0 && !sizeTopic) {
                try {
                    Thread.sleep(600000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (sizeQueue <= 0) continue;
            GCUBEMessage message = null;
            ConcurrentLinkedQueue<GCUBEMessage> concurrentLinkedQueue2 = messageForQueue;
            synchronized (concurrentLinkedQueue2) {
                message = messageForQueue.poll();
            }
            this.sendMessageToQueue(message);
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    static {
        MAX_MONITORING_QUEUE_SIZE = 1000;
        MAX_ACCOUNTING_QUEUE_SIZE = 1000;
        messageForQueue = null;
        ackMode = 1;
        transacted = false;
        singleton = new Producer();
        messageForQueue = new ConcurrentLinkedQueue();
        Thread t = new Thread(singleton);
        t.start();
    }
}

