/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.worker.sync;

import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.VFS;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.datatransfer.agent.impl.grs.GRSOutComeWriter;
import org.gcube.datatransfer.agent.impl.worker.SyncWorker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageManagerDetails;

public class StorageManagerSyncWorker
extends SyncWorker {
    private static final long serialVersionUID = 1L;
    private IClient client;

    public StorageManagerSyncWorker(String id, SourceData source, DestData dest) throws Exception {
        this.sourceParameters = source;
        this.destParameters = dest;
        this.transferId = id;
        StorageManagerDetails details = dest.getOutUri().getOptions().getStorageManagerDetails();
        if (details == null) {
            throw new Exception("Missing storage Manager configuration details");
        }
        this.client = new StorageClient(details.getServiceClass(), details.getServiceName(), details.getOwner(), AccessType.valueOf((String)details.getAccessType().getValue()), source.getScope()).getClient();
        this.outcomeWriter = new GRSOutComeWriter(source.getInputURIs().length, false);
    }

    public Object call() throws Exception {
        File tmpFile;
        String[] urlInputs = this.sourceParameters.getInputURIs();
        String outPath = this.destParameters.getOutUri().getOutUris()[0];
        int timeout = (int)this.destParameters.getOutUri().getOptions().getTransferTimeout();
        String outURL = null;
        try {
            tmpFile = File.createTempFile("data-transfer", ".tmp");
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return e1;
        }
        FileOutputStream streamOut = null;
        InputStream streamIn = null;
        for (String urlString : urlInputs) {
            Exception exception = null;
            long startTime = 0L;
            long endTime = 0L;
            try {
                FileObject file = VFS.getManager().resolveFile(urlString);
                URLConnection connection = file.getURL().openConnection();
                connection.setConnectTimeout(timeout);
                streamIn = connection.getInputStream();
                try {
                    streamOut = new FileOutputStream(tmpFile);
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                    return e1;
                }
                String outputFile = urlString.substring(urlString.lastIndexOf(File.separator) + 1);
                String absoluteOutputFile = outPath + File.separator + outputFile;
                startTime = System.currentTimeMillis();
                IOUtils.copy((InputStream)streamIn, (OutputStream)streamOut);
                streamIn.close();
                streamOut.close();
                this.client.put(true).LFile(tmpFile.getAbsolutePath()).RFile(absoluteOutputFile);
                outURL = this.client.getUrl().RFile(absoluteOutputFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                exception = e;
            }
            endTime = System.currentTimeMillis();
            long transferTime = endTime - startTime;
            if (exception == null) {
                this.outcomeWriter.putField(urlString, outURL, transferTime, new Long(0L), new Long(0L), new Exception[0]);
                continue;
            }
            this.outcomeWriter.putField(urlString, outURL, transferTime, new Long(0L), new Long(0L), exception);
        }
        tmpFile.delete();
        this.outcomeWriter.close();
        return true;
    }

    @Override
    public String getOutcomeLocator() throws GRS2WriterException {
        return this.outcomeWriter.writer.getLocator().toString();
    }
}

