/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.FutureTask;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.worker.Worker;
import org.globus.wsrf.ResourceException;

public class AgentResource
extends GCUBEWSResource {
    private HashMap<String, FutureWorker> workerMap = null;
    protected static final String supportedTransferRP = "SupportedTransfer";
    protected static final String fileSystemRootRP = "FileSystemRoot";
    protected static String[] RPNames = new String[]{"FileSystemRoot", "SupportedTransfer"};

    protected String[] getTopicNames() {
        return RPNames;
    }

    protected void initialise(Object ... o) throws ResourceException {
        this.logger.debug((Object)"Initialising the Agent-Resource...");
        this.initialiseRPs();
        this.logger.debug((Object)"Agent-Resource RPs initialised");
    }

    public HashMap<String, FutureWorker> getWorkerMap() {
        if (this.workerMap == null) {
            this.workerMap = new HashMap();
        }
        return this.workerMap;
    }

    public void setWorkerMap(HashMap<String, FutureWorker> workerMaps) {
        this.workerMap = workerMaps;
        this.store();
    }

    public void setSupportedTransfer(String property) {
        this.getResourcePropertySet().get(supportedTransferRP).clear();
        this.getResourcePropertySet().get(supportedTransferRP).add((Object)property);
        this.store();
    }

    public ArrayList<String> getSupportedTransfer() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = this.getResourcePropertySet().get(supportedTransferRP).iterator();
        while (it.hasNext()) {
            list.add((String)it.next());
        }
        return list;
    }

    public void setFileSystemRoot(String property) {
        this.getResourcePropertySet().get(fileSystemRootRP).clear();
        this.getResourcePropertySet().get(fileSystemRootRP).add((Object)property);
        this.store();
    }

    public String getFileSystemRoot() {
        return (String)this.getResourcePropertySet().get(supportedTransferRP).get(0);
    }

    private void initialiseRPs() {
        this.getResourcePropertySet().get(supportedTransferRP).clear();
        this.getResourcePropertySet().get(fileSystemRootRP).clear();
        try {
            for (String transfer : ServiceContext.getContext().getSupportedTransfers()) {
                this.getResourcePropertySet().get(supportedTransferRP).add((Object)transfer);
            }
            this.getResourcePropertySet().get(fileSystemRootRP).add((Object)ServiceContext.getContext().getVfsRoot());
        }
        catch (Exception e) {
            this.logger.debug((Object)"Error inizializing RPs", (Throwable)e);
        }
        this.store();
    }

    public static class FutureWorker {
        FutureTask futureTask;
        Worker worker;

        public FutureWorker() {
        }

        public FutureWorker(FutureTask futureTask, Worker worker) {
            this.futureTask = futureTask;
            this.worker = worker;
        }

        public FutureTask getFutureTask() {
            return this.futureTask;
        }

        public Worker getWorker() {
            return this.worker;
        }

        public void setFutureTask(FutureTask futureTask) {
            this.futureTask = futureTask;
        }

        public void setWorker(Worker worker) {
            this.worker = worker;
        }
    }
}

