/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.handlers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.net.io.Util;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.handlers.TransferHandler;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.PostProcessType;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class LocalFileTransferHandlerWithoutVFS
extends TransferHandler {
    public static int bufferSize = 1024000;
    CopyStreamListener listener = new CopyStreamListener(){

        public void bytesTransferred(long arg0, int arg1, long arg2) {
            try {
                ServiceContext.getContext().getDbManager().updateTransferObjectInfo(LocalFileTransferHandlerWithoutVFS.this.transferId, arg1);
            }
            catch (Exception e) {
                LocalFileTransferHandlerWithoutVFS.this.logger.error((Object)"Error updating DB");
            }
        }

        public void bytesTransferred(CopyStreamEvent arg0) {
        }
    };

    public LocalFileTransferHandlerWithoutVFS(String[] inputFiles, String outPath, String transferId, TransferType type, DestData data, int startIndex, int endIndex) {
        this.inputFiles = inputFiles;
        this.timeout = data.getOutUri().getOptions().getTransferTimeout();
        this.outPath = outPath;
        this.transferId = transferId;
        this.transferType = type;
        this.destData = data;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (int i = this.startIndex; i <= this.endIndex; ++i) {
            long startTime = 0L;
            TransferObject transferObj = null;
            try {
                String outputFile;
                transferObj = TransferUtils.createTransferObjectJDO(this.transferId, this.transferType);
                transferObj.setSourceURI(this.inputFiles[i]);
                URL url = new URL(this.inputFiles[i]);
                URLConnection connection = url.openConnection();
                transferObj.setSize(new Long(0L));
                if (this.inputFiles[i].startsWith("smp")) {
                    String str = this.inputFiles[i];
                    String[] parts = str.split("\\?");
                    String[] partsOfMain = parts[0].split("/");
                    outputFile = partsOfMain[partsOfMain.length - 1];
                } else {
                    outputFile = this.inputFiles[i].substring(this.inputFiles[i].lastIndexOf("/") + 1, this.inputFiles[i].length());
                }
                if (this.outPath.endsWith("/")) {
                    this.outPath = this.outPath.substring(0, this.outPath.length() - 1);
                }
                String relativeOutputFile = this.outPath + File.separator + outputFile;
                this.logger.debug((Object)("Relative Output file " + relativeOutputFile));
                String absoluteOutputFile = ServiceContext.getContext().getVfsRoot() + File.separator + relativeOutputFile;
                String absolutePath = ServiceContext.getContext().getVfsRoot() + File.separator + this.outPath;
                new File(absolutePath).mkdirs();
                if (new File(absoluteOutputFile).exists() && !this.destData.getOutUri().getOptions().isOverwrite()) {
                    this.logger.error((Object)("the file represented by the URL " + this.inputFiles[i] + " cannot be copied cause a file with the same name already exists"));
                    throw new Exception("the file represented by the URL " + this.inputFiles[i] + " cannot be copied cause a local file with the same name already exists");
                }
                transferObj.setDestURI(absoluteOutputFile);
                this.logger.debug((Object)("Copying file from URL " + this.inputFiles[i] + " to : " + absoluteOutputFile));
                startTime = System.currentTimeMillis();
                InputStream sourceFileIn = connection.getInputStream();
                try {
                    FileOutputStream destinationFileOut = new FileOutputStream(new File(absoluteOutputFile));
                    try {
                        Util.copyStream((InputStream)sourceFileIn, (OutputStream)destinationFileOut, (int)bufferSize, (long)connection.getContentLength(), (CopyStreamListener)this.listener);
                    }
                    finally {
                        ((OutputStream)destinationFileOut).close();
                    }
                }
                finally {
                    sourceFileIn.close();
                }
                PostProcessType[] postProcesses = this.destData.getOutUri().getOptions().getPostProcess();
                if (postProcesses != null) {
                    for (PostProcessType process : postProcesses) {
                        TransferUtils.applyPostProcess(process, absoluteOutputFile, absolutePath, this.destData.getOutUri().getOptions().getConversionType());
                    }
                }
                transferObj.setStatus(TransferStatus.DONE.name());
                transferObj.setOutcome("File succesfully copied to " + absoluteOutputFile);
                this.logger.debug((Object)("File succesfully copied to " + absoluteOutputFile));
                ServiceContext.getContext().getDbManager().addTransferObjectCompleted(this.transferId);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                transferObj.setStatus(TransferStatus.FAILED.name());
                transferObj.setOutcome(e.toString());
                this.errorHappened = true;
                continue;
            }
            finally {
                long endTime = System.currentTimeMillis();
                transferObj.setTransferTime(endTime - startTime);
                this.transferObjs.add(transferObj);
            }
        }
    }
}

