/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.handlers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.DecryptSmpUrl;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.handlers.CopyStreamHandler;
import org.gcube.datatransfer.agent.impl.handlers.TransferHandler;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.PostProcessType;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class LocalFileTransferAsyncHandler
extends TransferHandler {
    public static int bufferSize = 1024000;
    private long bytesTransferredForCurrent;
    private ExecutorService pool;
    CopyStreamListener listener = new CopyStreamListener(){

        public void bytesTransferred(long arg0, int arg1, long arg2) {
            try {
                ServiceContext.getContext().getDbManager().updateTransferObjectInfo(LocalFileTransferAsyncHandler.this.transferId, arg1);
                LocalFileTransferAsyncHandler.this.bytesTransferredForCurrent = LocalFileTransferAsyncHandler.this.bytesTransferredForCurrent + (long)arg1;
            }
            catch (Exception e) {
                LocalFileTransferAsyncHandler.this.logger.error((Object)"Error updating DB");
            }
        }

        public void bytesTransferred(CopyStreamEvent arg0) {
        }
    };

    public LocalFileTransferAsyncHandler(String[] inputFiles, String outPath, String transferId, TransferType type, DestData data, int startIndex, int endIndex) {
        this.inputFiles = inputFiles;
        this.timeout = data.getOutUri().getOptions().getTransferTimeout();
        this.outPath = outPath;
        this.transferId = transferId;
        this.transferType = type;
        this.destData = data;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (int i = this.startIndex; i <= this.endIndex; ++i) {
            this.pool = Executors.newFixedThreadPool(1);
            long startTime = 0L;
            TransferObject transferObj = null;
            try {
                String outputFile;
                transferObj = TransferUtils.createTransferObjectJDO(this.transferId, this.transferType);
                transferObj.setSourceURI(this.inputFiles[i]);
                FileObject inputFile = TransferUtils.prepareFileObject(this.inputFiles[i]);
                transferObj.setSize(inputFile.getContent().getSize());
                if (!this.checkAvailableSize(inputFile.getContent().getSize())) {
                    String msg = "There is no available space in the destination!!";
                    this.logger.error((Object)msg);
                    throw new Exception(msg);
                }
                InputStream sourceFileIn = inputFile.getContent().getInputStream();
                if (inputFile.getURL().toString().startsWith("smp")) {
                    String str = this.inputFiles[i];
                    String[] parts = str.split("\\?");
                    if (sourceFileIn == null) {
                        String rpath = parts[0].replaceFirst("smp:/", "");
                        this.logger.debug((Object)("rpath=" + rpath));
                        DecryptSmpUrl.decrypt((String)parts[1]);
                        GCUBEScope scope = GCUBEScope.getScope((String)DecryptSmpUrl.scopeType);
                        ScopeProvider.instance.set(scope.toString());
                        IClient clientNew = new StorageClient(DecryptSmpUrl.serviceClass, DecryptSmpUrl.serviceName, DecryptSmpUrl.owner, AccessType.valueOf((String)DecryptSmpUrl.accessType.toUpperCase())).getClient();
                        sourceFileIn = clientNew.get().RFileAsInputStream(rpath);
                    }
                    String[] partsOfMain = parts[0].split("/");
                    outputFile = partsOfMain[partsOfMain.length - 1];
                } else {
                    outputFile = inputFile.getName().getBaseName();
                }
                if (this.outPath.endsWith("/")) {
                    this.outPath = this.outPath.substring(0, this.outPath.length() - 1);
                }
                String relativeOutputFile = this.outPath + File.separator + outputFile;
                this.logger.debug((Object)("Relative Output file " + relativeOutputFile));
                FileObject absoluteOutputFile = ServiceContext.getContext().getLocalFSManager().resolveFile(relativeOutputFile);
                FileObject absolutePath = ServiceContext.getContext().getLocalFSManager().resolveFile(this.outPath);
                absolutePath.createFolder();
                if (absoluteOutputFile.exists() && !this.destData.getOutUri().getOptions().isOverwrite()) {
                    String msg = "the file represented by the URL " + inputFile.getURL().toString() + " cannot be copied cause a file with the same name already exists";
                    this.logger.error((Object)msg);
                    throw new Exception(msg);
                }
                transferObj.setDestURI(absoluteOutputFile.getName().getPath());
                this.logger.debug((Object)("Copying file from URL " + inputFile.getURL() + " to : " + absoluteOutputFile.getName().getPath()));
                startTime = System.currentTimeMillis();
                boolean terminate = false;
                OutputStream destinationFileOut = absoluteOutputFile.getContent().getOutputStream();
                this.bytesTransferredForCurrent = 0L;
                CopyStreamHandler handler = new CopyStreamHandler(sourceFileIn, destinationFileOut, inputFile.getContent().getSize(), this.listener);
                try {
                    this.pool.execute(handler);
                    this.pool.shutdown();
                }
                catch (Exception e) {
                    this.pool.shutdownNow();
                    e.printStackTrace();
                    absoluteOutputFile.delete();
                    throw new Exception("Error while executing the transfer");
                }
                terminate = this.pool.awaitTermination(this.timeout, TimeUnit.MILLISECONDS);
                sourceFileIn.close();
                destinationFileOut.close();
                if (terminate) {
                    PostProcessType[] postProcesses = this.destData.getOutUri().getOptions().getPostProcess();
                    if (postProcesses != null) {
                        for (PostProcessType process : postProcesses) {
                            TransferUtils.applyPostProcess(process, absoluteOutputFile, absolutePath, this.destData.getOutUri().getOptions().getConversionType());
                        }
                    }
                    transferObj.setStatus(TransferStatus.DONE.name());
                    transferObj.setBytesOfObjTransferred(this.bytesTransferredForCurrent);
                    transferObj.setOutcome("File succesfully copied to " + absoluteOutputFile);
                    this.logger.debug((Object)("File succesfully copied to " + absoluteOutputFile));
                    ServiceContext.getContext().getDbManager().addTransferObjectCompleted(this.transferId);
                    continue;
                }
                String msg = "Transfer aborted because timeout has elapsed";
                this.logger.error((Object)msg);
                absoluteOutputFile.delete();
                throw new Exception(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
                transferObj.setStatus(TransferStatus.FAILED.name());
                transferObj.setOutcome(e.toString());
                transferObj.setBytesOfObjTransferred(0L);
                this.errorHappened = true;
                continue;
            }
            finally {
                long endTime = System.currentTimeMillis();
                transferObj.setTransferTime(endTime - startTime);
                this.transferObjs.add(transferObj);
            }
        }
    }

    public boolean checkAvailableSize(long size) {
        File root = new File("/");
        long total_usable_size = root.getUsableSpace();
        this.logger.debug((Object)("Total available space in the destination is " + total_usable_size));
        return total_usable_size > size;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[bufferSize];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void copyWithHttpClient(String inputURI, String outPutUri) throws Exception {
        HttpClient client = new HttpClient();
        GetMethod get = new GetMethod(inputURI);
        int status = client.executeMethod((HttpMethod)get);
        InputStream is = get.getResponseBodyAsStream();
        FileOutputStream fos = new FileOutputStream(outPutUri);
        LocalFileTransferAsyncHandler.copyLarge(is, fos);
        fos.close();
    }
}

