/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.event;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.agent.impl.event.TransferRequestChecker;
import org.gcube.datatransfer.common.messaging.messages.TransferRequestMessage;

public class TransferRequestListener
implements MessageListener {
    public static GCUBELog logger = new GCUBELog(TransferRequestListener.class);
    private GCUBEScope scope = null;
    private String subscriberEndpoint = null;
    private TransferRequestChecker requestChecker;

    public TransferRequestListener() {
    }

    public TransferRequestListener(GCUBEScope scope, String subscriberEndpoint) {
        logger.debug((Object)"The TransferRequestListener has been created ...");
        this.scope = scope;
        this.subscriberEndpoint = subscriberEndpoint;
        this.requestChecker = new TransferRequestChecker(this.scope, this.subscriberEndpoint);
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof ObjectMessage) {
                ObjectMessage msg = (ObjectMessage)message;
                if (msg.getObject() instanceof TransferRequestMessage) {
                    logger.debug((Object)"TransferRequestListener (onMessage) - a new message has just arrived...");
                    TransferRequestMessage req_msg = (TransferRequestMessage)msg.getObject();
                    this.requestChecker.check(req_msg);
                } else {
                    logger.debug((Object)"TransferRequestListener (onMessage) - a new message has just arrived but its not TransferRequestMessage...");
                }
            } else {
                logger.debug((Object)"TransferRequestListener (onMessage) - a new message has just arrived but its not ObjectMessage...");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

