/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.worker.async;

import java.util.HashSet;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.handlers.DataStorageTransferAsyncHandler;
import org.gcube.datatransfer.agent.impl.handlers.TransferHandler;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.impl.worker.ASyncWorker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class DataStorageASyncWorker
extends ASyncWorker {
    private static final long serialVersionUID = 1L;

    public DataStorageASyncWorker(String tranferID, SourceData source, DestData dest) {
        this.transferId = tranferID;
        this.sourceParameters = source;
        this.destParameters = dest;
    }

    public Object call() throws Exception {
        String[] urlInputs = this.sourceParameters.getInputURIs();
        String[] urlOutputs = this.destParameters.getOutUri().getOutUris();
        HashSet<TransferObject> transferObjects = new HashSet<TransferObject>();
        long totalsize = TransferUtils.getTotalSize(urlInputs);
        ServiceContext.getContext().getDbManager().updateTransferJDO(this.transferId, urlInputs, totalsize);
        if (urlInputs.length != urlOutputs.length) {
            throw new Exception("The input and output URI lists do not contain the same number of arguments");
        }
        ThreadGroup threadList = new ThreadGroup(this.transferId);
        int nPartitions = urlInputs.length / 100;
        int mod = urlInputs.length % 100;
        int startIndex = 0;
        int endIndex = 0;
        for (int j = 0; j < nPartitions; ++j) {
            startIndex = j * 100;
            endIndex = startIndex + 100 - 1;
            DataStorageTransferAsyncHandler transferHandler = new DataStorageTransferAsyncHandler(urlInputs, urlOutputs, this.transferId, TransferType.FileBasedTransfer, this.destParameters, startIndex, endIndex);
            this.list.add(transferHandler);
            Thread t = new Thread(threadList, transferHandler);
            t.start();
        }
        if (mod != 0) {
            DataStorageTransferAsyncHandler transferHandler = new DataStorageTransferAsyncHandler(urlInputs, urlOutputs, this.transferId, TransferType.FileBasedTransfer, this.destParameters, endIndex, endIndex + mod - 1);
            this.list.add(transferHandler);
            Runnable t = new Thread(threadList, transferHandler);
            ((Thread)t).start();
        }
        try {
            Thread[] tga = new Thread[threadList.activeCount()];
            threadList.enumerate(tga);
            for (Thread t : tga) {
                this.logger.debug((Object)("waiting for thread" + t.getId()));
                t.join();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        this.logger.debug((Object)"Getting transferOBJList");
        for (Runnable t : this.list) {
            transferObjects.addAll(((TransferHandler)t).getTransferObjList());
            if (this.errorHappened) continue;
            this.errorHappened = ((TransferHandler)t).isErrorHappened();
        }
        try {
            this.logger.debug((Object)"Persisting objects");
            ServiceContext.getContext().getDbManager().storeTransferObject(transferObjects);
            if (this.errorHappened) {
                ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, TransferStatus.DONE_WITH_ERRORS.name());
            } else {
                ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, TransferStatus.DONE.name());
            }
        }
        catch (Exception e) {
            ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, TransferStatus.FAILED.name());
            e.printStackTrace();
            throw e;
        }
        return true;
    }
}

