/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.jdo.Transfer;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.GdalConverter;
import org.gcube.datatransfer.agent.impl.vfs.HttpFileSystemConfBuilderPatched;
import org.gcube.datatransfer.agent.stubs.datatransferagent.PostProcessType;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;
import org.gcube.datatransfer.common.options.TransferOptions;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class TransferUtils {
    static GCUBELog logger = new GCUBELog(TransferUtils.class);
    static final int BUFFER = 2048;
    protected static final UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();

    public static Transfer createTransferJDO(String transferId) {
        Transfer t = new Transfer();
        t.setId(transferId);
        t.setStatus(TransferStatus.QUEUED.name());
        t.setSubmitter("N/A");
        t.setTransfersCompleted(0L);
        t.setTotalSize(0L);
        t.setTransfersCompleted(0L);
        t.setTotalTransfers(0L);
        return t;
    }

    public static long getTotalSize(String[] inputURIs) throws Exception {
        long totalBytes = 0L;
        for (int i = 0; i < inputURIs.length; ++i) {
            try {
                logger.debug((Object)("Trying to obtain the size of the URI : " + inputURIs[i]));
                FileObject inputFile = TransferUtils.prepareFileObject(inputURIs[i]);
                logger.debug((Object)("the size is  : " + inputFile.getContent().getSize()));
                totalBytes += inputFile.getContent().getSize();
                continue;
            }
            catch (FileSystemException ex) {
                logger.error((Object)("Error getting the size of file :" + inputURIs[i]));
                ex.printStackTrace();
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("Error getting the size of file :" + inputURIs[i]));
                e.printStackTrace();
            }
        }
        return totalBytes;
    }

    public static TransferObject createTransferObjectJDO(String transferId, TransferType type) {
        TransferObject t = new TransferObject();
        t.setId(uuidgen.nextUUID());
        t.setTransferType(type);
        t.setStatus(TransferStatus.STARTED.name());
        t.setTransferID(transferId);
        return t;
    }

    public static void unzipArchive(String baseFolder, String archiveFile) throws Exception {
        ZipEntry entry;
        BufferedOutputStream dest = null;
        FileInputStream fis = new FileInputStream(archiveFile);
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
        while ((entry = zis.getNextEntry()) != null) {
            int count;
            byte[] data = new byte[2048];
            String outFile = baseFolder + File.separator + entry.getName();
            FileOutputStream fos = new FileOutputStream(outFile);
            logger.debug((Object)("Uncompressing file " + outFile));
            dest = new BufferedOutputStream(fos, 2048);
            while ((count = zis.read(data, 0, 2048)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
        }
        zis.close();
    }

    public static String getMimeType(String fileUrl) throws IOException {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String type = fileNameMap.getContentTypeFor(fileUrl);
        return type;
    }

    public static FileSystemOptions createDefaultOptions(String URI2) throws FileSystemException {
        FileSystemOptions opts = new FileSystemOptions();
        int timeout = ServiceContext.getContext().getConnectionTimeout();
        if (URI2.startsWith("ftp://")) {
            FtpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(opts, true);
            FtpFileSystemConfigBuilder.getInstance().setSoTimeout(opts, Integer.valueOf(timeout));
            FtpFileSystemConfigBuilder.getInstance().setDataTimeout(opts, Integer.valueOf(timeout));
            return opts;
        }
        if (URI2.startsWith("sftp://")) {
            SftpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(opts, true);
            SftpFileSystemConfigBuilder.getInstance().setTimeout(opts, Integer.valueOf(timeout));
            return opts;
        }
        if (!URI2.startsWith("s3://") && (URI2.startsWith("http://") || URI2.startsWith("http://"))) {
            HttpFileSystemConfBuilderPatched.getInstance().setTimeout(opts, timeout);
            return opts;
        }
        return null;
    }

    public static FileObject prepareFileObject(String URI2) throws FileSystemException {
        return VFS.getManager().resolveFile(URI2, TransferUtils.createDefaultOptions(URI2));
    }

    public static boolean applyPostProcess(PostProcessType type, FileObject file, FileObject path, String conversionType) throws Exception {
        if (type.getValue().compareTo(PostProcessType.FileConversion.getValue()) == 0) {
            if (conversionType == null) {
                throw new Exception("File Conversione Type not specified");
            }
            if (conversionType.compareTo(TransferOptions.ConversionType.GEOTIFF.name()) == 0) {
                GdalConverter.convertToGeoTiff(file.getName().getPath());
            }
        } else if (type.getValue().compareTo(PostProcessType.FileUnzip.getValue()) == 0) {
            TransferUtils.unzipArchive(path.getName().getPath(), file.getName().getPath());
        } else if (type.getValue().compareTo(PostProcessType.OriginalFileRemove.getValue()) == 0) {
            file.delete();
        }
        return true;
    }

    public static boolean applyPostProcess(PostProcessType type, String file, String path, String conversionType) throws Exception {
        if (type.getValue().compareTo(PostProcessType.FileConversion.getValue()) == 0) {
            if (conversionType == null) {
                throw new Exception("File Conversione Type not specified");
            }
            if (conversionType.compareTo(TransferOptions.ConversionType.GEOTIFF.name()) == 0) {
                GdalConverter.convertToGeoTiff(file);
            }
        } else if (type.getValue().compareTo(PostProcessType.FileUnzip.getValue()) == 0) {
            TransferUtils.unzipArchive(path, file);
        } else if (type.getValue().compareTo(PostProcessType.OriginalFileRemove.getValue()) == 0) {
            new File(file).delete();
        }
        return true;
    }
}

