/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.db.DBManager;
import org.gcube.datatransfer.agent.impl.grs.GRSOutComeWriter;
import org.gcube.datatransfer.agent.impl.jdo.Transfer;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.stubs.datatransferagent.MonitorTransferReportMessage;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class DataTransferDBManager
extends DBManager
implements Runnable {
    GCUBELog logger = new GCUBELog(DataTransferDBManager.class);

    public DataTransferDBManager() throws Exception {
        this.dbFileBaseFolder = ServiceContext.getContext().getPersistenceRoot().getAbsolutePath() + File.separator + "DataTransferDB";
        this.dbName = "data_transfer";
        this.dbFileName = this.dbFileBaseFolder + File.separator + this.dbName + ".db";
        backupFolder = new File(System.getenv("HOME") + File.separator + "DataTransferDBBackup");
        Properties prop = new Properties();
        String propFile = GHNContext.getContext().getLocation() + File.separator + ServiceContext.getContext().getProperty("configDir", new boolean[]{true}) + File.separator + ServiceContext.getContext().getDbConfigurationFileName();
        try {
            prop.load(new FileInputStream(new File(propFile)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.persistenceFactory = JDOHelper.getPersistenceManagerFactory((Map)prop);
        Thread t = new Thread(this);
        t.start();
    }

    public void storeTransfer(Transfer transfer) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)transfer);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void storeTransferObject(Set<TransferObject> transferObjects) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            for (TransferObject obj : transferObjects) {
                persistenceManager.currentTransaction().begin();
                persistenceManager.makePersistent((Object)obj);
                persistenceManager.currentTransaction().commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public String getTransferStatus(String transferId) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
        persistenceManager.close();
        return t.getStatus();
    }

    public void updateTransferObjectStatus(String objId, String status) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)objId);
        this.logger.debug((Object)("Old status " + t.getStatus()));
        t.setStatus(status);
        this.logger.debug((Object)("New Status " + t.getStatus()));
        persistenceManager.makePersistent((Object)t);
        persistenceManager.close();
    }

    public void updateTransferObjectInfo(String objId, long size) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)objId);
        t.setSizeTransferred(t.getSizeTransferred() + size);
        persistenceManager.makePersistent((Object)t);
        persistenceManager.close();
    }

    public void addTransferObjectCompleted(String objId) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)objId);
        this.logger.debug((Object)("Old completed" + t.getTransfersCompleted()));
        t.setTransfersCompleted(t.getTransfersCompleted() + 1L);
        this.logger.debug((Object)("New completed" + t.getTransfersCompleted()));
        persistenceManager.makePersistent((Object)t);
        persistenceManager.close();
    }

    public void updateTransferJDO(String transferId, String[] inputURIs, long totalsize) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
        t.setId(transferId);
        t.setStatus(TransferStatus.STARTED.name());
        t.setSubmitter("N/A");
        t.setTransfersCompleted(0L);
        t.setTotalSize(totalsize);
        t.setTransfersCompleted(0L);
        t.setTotalTransfers(inputURIs.length);
        persistenceManager.makePersistent((Object)t);
        persistenceManager.close();
    }

    @Override
    public void run() {
        do {
            try {
                Thread.sleep(backupIntervalMS);
                this.backup();
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"Unable to sleep", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to backup", (Throwable)e);
            }
        } while (!Thread.interrupted());
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceFactory.getPersistenceManager();
    }

    public String getTransferObjectOutComeAsRS(String transferId) throws Exception {
        GRSOutComeWriter outcomeWriter = null;
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
        if (!TransferStatus.valueOf((String)t.getStatus()).hasCompleted()) {
            outcomeWriter = new GRSOutComeWriter(1);
            outcomeWriter.putField(transferId, "", new Long(0L), new Exception("The submitted transfer is not yet completed"));
        } else {
            Query query = persistenceManager.newQuery(TransferObject.class);
            query.setFilter("transferID == \"" + transferId + "\"");
            List list = (List)query.execute();
            if (list == null || list.size() == 0) {
                throw new Exception("The Transfer Objects list is empty");
            }
            this.logger.debug((Object)("Getting " + list.size() + " outcomes"));
            outcomeWriter = new GRSOutComeWriter(list.size());
            for (TransferObject obj : list) {
                if (obj.getStatus().compareTo(TransferStatus.FAILED.name()) == 0) {
                    outcomeWriter.putField(obj.getSourceURI(), obj.getDestURI(), obj.getTransferTime(), new Exception(obj.getOutcome()));
                } else {
                    outcomeWriter.putField(obj.getSourceURI(), obj.getDestURI(), obj.getTransferTime(), new Exception[0]);
                }
                persistenceManager.deletePersistent((Object)obj);
            }
        }
        persistenceManager.close();
        return outcomeWriter.writer.getLocator().toString();
    }

    public MonitorTransferReportMessage getTrasferProgress(String transferId) {
        MonitorTransferReportMessage message = new MonitorTransferReportMessage();
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
        message.setTransferID(transferId);
        message.setTotalBytes(t.getTotalSize());
        message.setTotalTransfers((int)t.getTotaltransfers());
        message.setTransferCompleted((int)t.getTransfersCompleted());
        message.setBytesTransferred(t.getSizeTransferred());
        message.setTransferStatus(t.getStatus());
        persistenceManager.close();
        return message;
    }
}

