package org.gcube.datatransfer.agent.impl.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;

import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.common.outcome.TransferStatus;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;

/**
 * 
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class StorageManagerAsyncHandler extends TransferHandler{

	IClient client = null;


	public StorageManagerAsyncHandler (String [] inputFiles, 
			String outPath,String transferId, TransferType type,IClient client, DestData data, int startIndex, int endIndex){
		this.inputFiles = inputFiles;
		this.timeout = data.getOutUri().getOptions().getTransferTimeout();;
		this.outPath = outPath;
		this.transferId = transferId;
		this.transferType = type;
		this.destData = data;
		this.client = client;
		this.startIndex = startIndex;
		this.endIndex = endIndex;

	}


	@Override
	public void run() {


		for (int i =startIndex; i<=endIndex ; i++){
			long startTime = 0;
			File tmpFile = null;
			TransferObject transferObj = null;

			try {
				transferObj =TransferUtils.createTransferObjectJDO(transferId,transferType);
				transferObj.setSourceURI(inputFiles[i]);


				FileObject inputFile = TransferUtils.prepareFileObject(inputFiles[i]);

				URLConnection connection = inputFile.getURL().openConnection();
				connection.setConnectTimeout((int)timeout);
				InputStream streamIn = connection.getInputStream();

				try {
					tmpFile = File.createTempFile("data-transfer", ".tmp");
				} catch (IOException e1) {
					e1.printStackTrace();
					throw e1;
				}

				FileOutputStream streamOut = null;
				try {
					streamOut = new FileOutputStream(tmpFile);
				} catch (FileNotFoundException e1) {
					e1.printStackTrace();
				}


				//getting outfile info	
				String outputFile = inputFile.getName().getBaseName();
				String absoluteOutputFile = outPath+File.separator+outputFile;


				startTime= System.currentTimeMillis();

				IOUtils.copy(streamIn, streamOut);
				streamIn.close();
				streamOut.close();

				client.put(true).LFile(tmpFile.getAbsolutePath()).RFile(absoluteOutputFile);	
				String outURL = client.getUrl().RFile(absoluteOutputFile);

				transferObj.setDestURI(outURL);
				transferObj.setSize(tmpFile.getTotalSpace());
				transferObj.setStatus(TransferStatus.DONE.name());

				transferObj.setOutcome("File succesfully copied to "+ outURL);

				logger.debug("File succesfully copied to "+ outURL);

			}catch (Exception e){
				transferObj.setStatus(TransferStatus.FAILED.name());
				transferObj.setOutcome(e.toString());
				e.printStackTrace();
				errorHappened = true;
			}
			finally {
				long endTime = System.currentTimeMillis();
				transferObj.setTransferTime(endTime - startTime);
				tmpFile.delete();
				transferObjs.add(transferObj);

			}
		}
	}

}


