/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.handlers;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.gcube.datatransfer.agent.impl.handlers.TransferHandler;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class DataStorageTransferAsyncHandler
extends TransferHandler {
    StandardFileSystemManager fsManager = new StandardFileSystemManager();
    protected String[] outputFiles = null;

    public DataStorageTransferAsyncHandler(String[] inputFiles, String[] outputFiles, String transferId, TransferType type, DestData data, int startIndex, int endIndex) throws FileSystemException {
        this.inputFiles = inputFiles;
        this.timeout = data.getOutUri().getOptions().getTransferTimeout();
        this.outputFiles = outputFiles;
        this.transferId = transferId;
        this.transferType = type;
        this.destData = data;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.fsManager.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (int i = this.startIndex; i <= this.endIndex; ++i) {
            long startTime = 0L;
            TransferObject transferObj = null;
            try {
                transferObj = TransferUtils.createTransferObjectJDO(this.transferId, this.transferType);
                transferObj.setSourceURI(this.inputFiles[i]);
                transferObj.setDestURI(this.outputFiles[i]);
                FileObject inputFile = TransferUtils.prepareFileObject(this.inputFiles[i]);
                FileObject outputFile = TransferUtils.prepareFileObject(this.outputFiles[i]);
                this.logger.debug((Object)("Copy file from URL " + inputFile.getURL() + " to : " + outputFile.getURL()));
                if (outputFile.exists() && !this.destData.getOutUri().getOptions().isOverwrite()) {
                    this.logger.error((Object)"the file cannot be copied cause a file with the same name already exists");
                    throw new Exception("the file cannot be copied cause a  file with the same name already exists");
                }
                startTime = System.currentTimeMillis();
                outputFile.copyFrom(inputFile, Selectors.SELECT_SELF);
                this.logger.debug((Object)("File succesfully copied to " + outputFile.getURL().toURI()));
                transferObj.setSize(inputFile.getContent().getSize());
                transferObj.setStatus(TransferStatus.DONE.name());
                transferObj.setOutcome("File succesfully copied to " + outputFile.getURL().toURI());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                transferObj.setStatus(TransferStatus.FAILED.name());
                transferObj.setOutcome(e.toString());
                this.errorHappened = true;
                continue;
            }
            finally {
                long endTime = System.currentTimeMillis();
                transferObj.setTransferTime(endTime - startTime);
                this.transferObjs.add(transferObj);
            }
        }
    }
}

