/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.worker.async;

import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.common.clients.queries.Query;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.delegates.StreamListener;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tml.proxies.TReader;
import org.gcube.data.tml.proxies.TServiceFactory;
import org.gcube.data.tml.proxies.TWriter;
import org.gcube.data.trees.data.Tree;
import org.gcube.datatransfer.agent.impl.event.Events;
import org.gcube.datatransfer.agent.impl.streams.IdRemover;
import org.gcube.datatransfer.agent.impl.streams.StreamCopyListener;
import org.gcube.datatransfer.agent.impl.utils.Utils;
import org.gcube.datatransfer.agent.impl.worker.ASyncWorker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;

public class TreeManagerAsyncWorker
extends ASyncWorker {
    private static final long serialVersionUID = 1L;
    TWriter client_writer = null;
    TReader client_reader = null;
    StreamCopyListener listener = null;
    Stream<Tree> filtered = null;

    public TreeManagerAsyncWorker(String tranferID, SourceData source, DestData dest) {
        this.transferId = tranferID;
        this.sourceParameters = source;
        this.destParameters = dest;
        this.listener = new StreamCopyListener(tranferID, source, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() {
        this.logger.info((Object)"Preparing the transfer");
        Stream stream = null;
        try {
            StatefulQuery queryRead = TServiceFactory.readSource().withId(this.sourceParameters.getInputSource().getSourceId()).build();
            this.client_reader = (TReader)TServiceFactory.reader().matching((Query)queryRead).build();
            StatefulQuery queryWrite = TServiceFactory.writeSource().withId(this.destParameters.getOutSourceId()).build();
            this.client_writer = (TWriter)TServiceFactory.writer().matching((Query)queryWrite).build();
            ScopeProvider.instance.set(this.sourceParameters.getScope());
            stream = this.client_reader.get(Utils.getPattern(this.sourceParameters.getInputSource().getPattern()));
            this.filtered = Streams.pipe((Stream)stream).through((Generator)new IdRemover());
            this.filtered = Streams.monitor(this.filtered).with((StreamListener)this.listener);
            this.filtered = this.client_writer.add(this.filtered);
        }
        catch (Exception e) {
            this.listener.sendEvent(Events.TransferTopics.TRANSFER_FAIL, "Error performing the transfer!");
            this.logger.error((Object)("Error performing the transfer with id: " + this.transferId), (Throwable)e);
            Exception exception = e;
            return exception;
        }
        finally {
            try {
                this.getResource().getWorkerMap().remove(this.transferId);
            }
            catch (Exception e) {
                e.printStackTrace();
                return e;
            }
        }
        if (this.task.isCancelled()) {
            this.logger.debug((Object)("Transfer with id: " + this.transferId + " has been canceled"));
            this.listener.sendEvent(Events.TransferTopics.TRANSFER_CANCEL, "Transfer cancelled by the user!");
        }
        return true;
    }
}

