package org.gcube.datatransfer.agent.impl.worker.async;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.VFS;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.handlers.StorageManagerAsyncHandler;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.Constants.TransferStatus;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.impl.worker.ASyncWorker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageManagerDetails;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;

/**
 * 
 * 
 * @author andrea
 *
 */
public class StorageManagerASyncWorker extends ASyncWorker {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	GCUBELog logger = new GCUBELog(StorageManagerASyncWorker.class);

	private IClient client;
	

	public StorageManagerASyncWorker(String id,SourceData source, DestData dest) throws Exception {
		this.sourceParameters = source;
		this.destParameters = dest;
		this.transferId = id;

		StorageManagerDetails details = dest.getOutUri().getStorageManagerDetails();

		if (details == null)
			throw new Exception("Missing storage Manager configuration details");
		//to add parameter to dest Data
		client = new StorageClient(
				details.getServiceClass(), 
				details.getServiceName(),
				details.getOwner(),
				AccessType.valueOf(details.getAccessType().getValue()),
				GCUBEScope.getScope(source.getScope())).getClient();
		

	}

	@Override
	public Object call() throws Exception{

		String [] urlInputs= sourceParameters.getInputURIs();
		String outPath = destParameters.getOutUri().getOutUris()[0];


		Set<TransferObject> transferObjects = new HashSet<TransferObject>();
		ServiceContext.getContext().getDbManager().storeTransfer(TransferUtils.createTransferJDO(transferId));


		try{		

			ThreadGroup threadList = new ThreadGroup(transferId);

			for (String urlString : urlInputs) {
				FileObject file = VFS.getManager().resolveFile(urlString);
				StorageManagerAsyncHandler transferHandler =
						new StorageManagerAsyncHandler(file,timeout,outPath,transferId, 
								TransferType.FileBasedTransfer,client,destParameters);
				list.add(transferHandler);
				Thread t = new Thread(threadList,transferHandler);
				t.start();
			}
			try {
				Thread tga[] = new Thread[threadList.activeCount()]; 	
				threadList.enumerate(tga);

				for (Thread t : tga){
					logger.debug("waiting for thread" + t.getId()); 
					t.join();
				}

			}
			catch (Exception e){
				e.printStackTrace();
				throw e;

			}

			logger.debug("Getting transferOBJ");
			//getting transferObject
			for (StorageManagerAsyncHandler t :(ArrayList<StorageManagerAsyncHandler>)list){
				transferObjects.add(t.getTransferObj());
			}
			
			logger.debug("Persisting objects");
			ServiceContext.getContext().getDbManager().storeTransferObject(transferObjects);
			ServiceContext.getContext().getDbManager().updateTransferObjectStatus(transferId,TransferStatus.DONE.name());
			
		}
		catch (Exception e){
			ServiceContext.getContext().getDbManager().updateTransferObjectStatus(transferId,TransferStatus.FAILED.name());
			e.printStackTrace();
			return e;
		}
		return true;
	}

}
