package org.gcube.datatransfer.agent.impl.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.FutureTask;

import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.globus.wsrf.ResourceException;

/**
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class AgentResource extends GCUBEWSResource{

		private HashMap<String,FutureTask>  workerMap = null;
	
		protected static final String supportedTransferRP="SupportedTransfer";
		protected static final String fileSystemRootRP="FileSystemRoot";
		

		protected static String[] RPNames = {	fileSystemRootRP,supportedTransferRP	};
		
		@Override
		protected String[] getTopicNames() {		
			return RPNames;
		}
		
		/**
		 * 
		 *   Initializes Resource Properties. 
		 *   
		 *   @throws  Exception Exception
		 */
		protected void initialise(Object... o) throws ResourceException {
			logger.debug("Initialising the Agent-Resource...");
			/* Initialize the RP's */
			this.initialiseRPs();
			logger.debug("Agent-Resource RPs initialised");
			
				
		}
	
		public  HashMap<String, FutureTask> getWorkerMap() {
			if (this.workerMap == null)
				 this.workerMap = new  HashMap<String, FutureTask>();
			return this.workerMap;
		}

		public  void setWorkerMap(HashMap<String, FutureTask> workerMaps) {
			this.workerMap = workerMaps;
			this.store();
		}

		/** 
		 * Default Setter for the RP Generic
		 * 
		 * @param property the supported transfer property
		 * 
		 */ 
		public  void setSupportedTransfer (String property) {
			this.getResourcePropertySet().get(supportedTransferRP).clear();
			this.getResourcePropertySet().get(supportedTransferRP).add(property);
			this.store();
		}
		
		/** 
		 * Default getter for the RP Generic
		 * 
		 * @return   The Supported Trasnfers
		 * 
		 */ 
		public  ArrayList<String> getSupportedTransfer () {
			ArrayList<String> list = new ArrayList<String>();
			Iterator it =  this.getResourcePropertySet().get(supportedTransferRP).iterator() ;
			while (it.hasNext()){
				list.add((String)it.next());
			}				
			return list;
		}

		
		/** 
		 * Default Setter for the RP Generic
		 * 
		 * @param property the supported transfer property
		 * 
		 */ 
		public  void setFileSystemRoot (String property) {
			this.getResourcePropertySet().get(fileSystemRootRP).clear();
			this.getResourcePropertySet().get(fileSystemRootRP).add(property);
			this.store();
		}
		
		/** 
		 * Default getter for the RP Generic
		 * 
		 * @return   The Supported Trasnfers
		 * 
		 */ 
		public  String getFileSystemRoot () {	
			return (String)  this.getResourcePropertySet().get(supportedTransferRP).get(0) ;
		
		}
		private void initialiseRPs() {
		

			this.getResourcePropertySet().get(supportedTransferRP).clear();
			this.getResourcePropertySet().get(fileSystemRootRP).clear();
			
			try {
				for (String transfer :ServiceContext.getContext().getSupportedTransfers()){
					this.getResourcePropertySet().get(supportedTransferRP).add(transfer);
				}
				
				this.getResourcePropertySet().get(fileSystemRootRP).add(ServiceContext.getContext().getVfsRoot());
			
			
			}catch (Exception e ){
				logger.debug("Error inizializing RPs",e); 
			}
			this.store();
								
			
		}

}
