package org.gcube.datatransfer.agent.impl.handlers;


import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;

import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.utils.Constants.TransferStatus;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;

/**
 * 
 * @author andrea
 *
 */
public class LocalFileTransferAsyncHandler extends TransferHandler{

	GCUBELog logger = new GCUBELog (this.getClass());


	public LocalFileTransferAsyncHandler (FileObject inputFile, int timeout,
			String outPath,String transferId, TransferType type, DestData data){
		this.inputFile = inputFile;
		this.timeout = timeout;
		this.outPath = outPath;
		this.transferId = transferId;
		this.transferType = type;
		this.destData = data;

	}


	@Override
	public void run() {
		long startTime = 0;

		try {		

			URLConnection connection = inputFile.getURL().openConnection();
			connection.setConnectTimeout(timeout);
			InputStream streamIn = connection.getInputStream();


			//getting outfile info	
			String outputFile = inputFile.getName().getBaseName();
			String relativeOutputFile = outPath+File.separator+outputFile;
			
			FileObject absoluteOutputFile = ServiceContext.getContext().
					getLocalFSManager().resolveFile(relativeOutputFile);
			
			FileObject absolutePath =ServiceContext.getContext().
					getLocalFSManager().resolveFile(outPath);
			
			absolutePath.createFolder();
			
			if (absoluteOutputFile.exists() && !destData.getOutUri().isOverwrite())
			{
				logger.error("the file represented by the URL " + inputFile.getURL().toString() + " cannot be copied cause a file with the same name already exists");
				throw new Exception ("the file represented by the URL " + inputFile.getURL().toString() + " cannot be copied cause a local file with the same name already exists");
			}
			
			
			transferObj =TransferUtils.createTransferObjectJDO(transferId,transferType);
			transferObj.setDestURI(absoluteOutputFile.getName().getPath());
			transferObj.setSourceURI(inputFile.getURL().toString());
			
			
			OutputStream streamOut = null;
			try {
				streamOut = new FileOutputStream(absoluteOutputFile.getName().getPath());
			} catch (FileNotFoundException e1) {
				e1.printStackTrace();
				throw e1;
			}
			
			logger.debug("Copying file from URL "+ inputFile.getURL() + " to : " +absoluteOutputFile.getName().getPath());

			startTime= System.currentTimeMillis();

			IOUtils.copy(streamIn, streamOut);
			streamIn.close();
			streamOut.close();
			
			//check if the file has to be uncompressed
			if (destData.getOutUri().isUnzip())
			{
				TransferUtils.unzipArchive(absolutePath.getName().getPath(),absoluteOutputFile.getName().getPath());
				absoluteOutputFile.delete();
				
			}

			transferObj.setSize(absoluteOutputFile.getContent().getSize());
			transferObj.setStatus(TransferStatus.DONE.name());
			transferObj.setOutcome("File succesfully copied to "+ absoluteOutputFile);
			logger.debug("File succesfully copied to "+ absoluteOutputFile);
		}

		catch (Exception e){
			e.printStackTrace();
			transferObj.setStatus(TransferStatus.FAILED.name());
			transferObj.setOutcome(e.getMessage());
		}
		finally {
			long endTime = System.currentTimeMillis();
			transferObj.setTransferTime(endTime - startTime);
		}
	}

	
}


