/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.FutureTask;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.globus.wsrf.ResourceException;

public class AgentResource
extends GCUBEWSResource {
    private HashMap<String, FutureTask> workerMap = null;
    protected static final String supportedTransferRP = "supportedTransfer";
    protected static String[] RPNames = new String[]{"supportedTransfer"};

    protected String[] getTopicNames() {
        return RPNames;
    }

    protected void initialise(Object ... o) throws ResourceException {
        this.logger.debug((Object)"Initialising the Agent-Resource...");
        this.initialiseRPs();
        this.logger.debug((Object)"Agent-Resource RPs initialised");
    }

    public HashMap<String, FutureTask> getWorkerMap() {
        if (this.workerMap == null) {
            this.workerMap = new HashMap();
        }
        return this.workerMap;
    }

    public void setWorkerMap(HashMap<String, FutureTask> workerMaps) {
        this.workerMap = workerMaps;
        this.store();
    }

    public void setSupportedTransfer(String property) {
        this.getResourcePropertySet().get(supportedTransferRP).clear();
        this.getResourcePropertySet().get(supportedTransferRP).add((Object)property);
        this.store();
    }

    public ArrayList<String> getSupportedTransfer() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = this.getResourcePropertySet().get(supportedTransferRP).iterator();
        while (it.hasNext()) {
            list.add((String)it.next());
        }
        return list;
    }

    private void initialiseRPs() {
        this.getResourcePropertySet().get(supportedTransferRP).clear();
        try {
            String[] stringArray = ServiceContext.getContext().getSupportedTransfers();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String transfer = stringArray[n2];
                this.getResourcePropertySet().get(supportedTransferRP).add((Object)transfer);
                ++n2;
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)"Error inizializing RPs", (Throwable)e);
        }
        this.store();
    }
}

