/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.context;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.datatransfer.agent.impl.context.AgentContext;
import org.gcube.datatransfer.agent.impl.event.Events;
import org.gcube.datatransfer.agent.impl.event.TransferEventConsumer;
import org.gcube.datatransfer.agent.impl.utils.Constants;

public class ServiceContext
extends GCUBEServiceContext {
    public static final String JNDI_NAME = "gcube/datatransfer/agent";
    protected static final ServiceContext cache = new ServiceContext();
    private boolean useMessaging = false;
    public static GCUBEProducer<Events.TransferTopics, Object> transferEventproducer = new GCUBEProducer();

    private ServiceContext() {
    }

    public String[] getSupportedTransfers() throws Exception {
        String[] transfers = null;
        try {
            transfers = ((String)this.getProperty("supportedTransfers", new boolean[]{true})).split(",");
        }
        catch (RuntimeException e) {
            this.logger.debug((Object)"No Transfers available");
            throw new Exception("No Transfers available");
        }
        return transfers;
    }

    public static ServiceContext getContext() {
        return cache;
    }

    public String getJNDIName() {
        return JNDI_NAME;
    }

    protected void onInitialisation() throws Exception {
        this.setUseMessaging((Boolean)this.getProperty(Constants.USEMESSAGING_JNDI_NAME, new boolean[0]));
    }

    protected void onReady() throws Exception {
        super.onReady();
        this.logger.trace((Object)"creating agent resources in all RI scopes");
        AgentContext agentContext = AgentContext.getContext();
        for (GCUBEScope scope : this.getInstance().getScopes().values()) {
            this.setScope(scope);
            agentContext.createAgent();
        }
        this.logger.trace((Object)"creating transfer subscription");
        Events.TransferTopics[] transferTopicsArray = Events.TransferTopics.values();
        int n = transferTopicsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Events.TransferTopics topic = transferTopicsArray[n2];
            transferEventproducer.subscribe((GCUBEConsumer)new TransferEventConsumer(), (GCUBETopic[])new Events.TransferTopics[]{topic});
            ++n2;
        }
    }

    public boolean getUseMessaging() {
        return this.useMessaging;
    }

    public void setUseMessaging(boolean useMessaging) {
        this.useMessaging = useMessaging;
    }
}

