/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.streams;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.data.streams.delegates.StreamListenerAdapter;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.event.Events;
import org.gcube.datatransfer.agent.impl.event.TransferOutcome;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;

public class StreamCopyListener
extends StreamListenerAdapter {
    SourceData sourceParameters;
    DestData destParameters;
    String transferId;
    GCUBEEvent<Events.TransferTopics, TransferOutcome> event = null;

    public StreamCopyListener(String transferID, SourceData source, DestData dest) {
        this.transferId = transferID;
        this.sourceParameters = source;
        this.destParameters = dest;
    }

    public void onEnd() {
        this.sendEvent(Events.TransferTopics.TRANSFER_END, "Transfer Completed");
    }

    public void onStart() {
        this.sendEvent(Events.TransferTopics.TRANSFER_START, "Transfer Started");
    }

    public void sendEvent(Events.TransferTopics topic, String message) {
        this.event = new GCUBEEvent();
        TransferOutcome outcome = new TransferOutcome();
        outcome.setTransferId(this.transferId);
        outcome.setDestID(this.destParameters.getOutSourceId());
        outcome.setOutcome(message);
        outcome.setScope(GCUBEScope.getScope((String)this.destParameters.getScope()));
        outcome.setSourceID(this.sourceParameters.getInputSource().getSourceId());
        outcome.setTransferPhase(topic.name());
        outcome.setTransferType(this.sourceParameters.getType());
        this.event.setPayload((Object)outcome);
        ServiceContext.transferEventproducer.notify((GCUBETopic)topic, new GCUBEEvent[]{this.event});
    }
}

