package org.gcube.datatransfer.agent.impl.streams;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.data.streams.delegates.StreamListenerAdapter;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.event.TransferOutcome;
import org.gcube.datatransfer.agent.impl.event.Events.TransferTopics;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;


/**
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class StreamCopyListener extends StreamListenerAdapter{
	
	SourceData sourceParameters;
	DestData destParameters;
	String transferId;
	
	GCUBEEvent<TransferTopics,TransferOutcome> event = null;
	
	public StreamCopyListener(String transferID,SourceData source, DestData dest){
		this.transferId= transferID;
		this.sourceParameters = source;
		this.destParameters = dest;	
		
	}
	
	@Override
	public void onEnd() {
		sendEvent(TransferTopics.TRANSFER_END,"Transfer Completed");
	
	}
	
	@Override
	public void onStart() {
		sendEvent(TransferTopics.TRANSFER_START,"Transfer Started");
	
	}

	
	public void sendEvent(TransferTopics topic ,String message){
		event = new GCUBEEvent<TransferTopics,TransferOutcome> ();
		TransferOutcome outcome = new TransferOutcome();
		outcome.setTransferId(transferId);
		outcome.setDestID(destParameters.getOutSourceId());
		outcome.setOutcome(message);
		outcome.setScope(GCUBEScope.getScope(destParameters.getScope()));
		outcome.setSourceID(sourceParameters.getInputSource().getSourceId());
		outcome.setTransferPhase(topic.name());
		outcome.setTransferType(sourceParameters.getType());
		event.setPayload(outcome);
		ServiceContext.transferEventproducer.notify(topic, event);					
	}
}