package org.gcube.datatransfer.agent.impl.porttype;

import java.util.concurrent.FutureTask;

import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.agent.impl.context.AgentContext;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.state.AgentResource;
import org.gcube.datatransfer.agent.impl.worker.AgentTransferWorker;
import org.gcube.datatransfer.agent.impl.worker.TreeManagerWorker;
import org.gcube.datatransfer.agent.library.utils.Utils;
import org.gcube.datatransfer.agent.stubs.datatransferagent.CancelTransferFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.CancelTransferMessage;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StartTransferMessage;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;

/**
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class DataTransferAgent extends GCUBEPortType {

	protected final GCUBELog logger = new GCUBELog(DataTransferAgent.class);

	/** The UUIDGen */
	private static final UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();

	
	private AgentResource getResource() throws Exception {
		return (AgentResource) AgentContext.getContext().getAgent();
	}
	
	/**
	 * Starts a new transfer
	 * @param message
	 * @return
	 * @throws TransferFault
	 */
	public String startTransfer(StartTransferMessage message) throws TransferFault {
	
		
		logger.info("Start Transfer invoked in scope " + message.getSource().getScope());
		
		String id =  uuidgen.nextUUID();
		try {
			
			if (message.getSource().getType().getValue().compareTo(TransferType.TreeBasedTransfer.getValue())==0){
					
			 logger.debug("SOURCE ID :"+ message.getSource().getInputSource().getSourceId());
		     TreeManagerWorker worker= new TreeManagerWorker(id,message.getSource(), message.getDest());
			 FutureTask<TreeManagerWorker> task = new FutureTask<TreeManagerWorker> (worker);
			 worker.setTask(task);
			 Thread t = new Thread(task);
			 t.start();
			 getResource().getWorkerMap().put(id, task);
			 
			}
			else {
				logger.debug("Local transfer from  URI :"+ message.getSource().getInputURIs()[0]);
				AgentTransferWorker worker = new AgentTransferWorker(id,message.getSource(), message.getDest());
				return (String)worker.call();		
			}
		} catch (Exception e) {
			logger.error("Unable to perform the transfer", e);
			throw Utils.newFault(new TransferFault(), e);
		}			
		 return id;	
		
	}
	
	/**
	 * Cancel a  transfer
	 * @param message
	 * @return
	 * @throws TransferFault
	 * @throws GCUBEFault 
	 */
	public String cancelTransfer(CancelTransferMessage message) throws CancelTransferFault {
		String handlerID = message.getTransferID();
		FutureTask handler = null;
		try {
			handler = getResource().getWorkerMap().get(handlerID);
			if (handler != null) {
				
				handler.cancel(message.isForceStop());
			}
			else logger.debug("null handler");
		} catch (Exception e) {
			logger.error("Unable to cancel the transfer", e);
			 throw Utils.newFault(new CancelTransferFault(), e);
		}	
		finally{
			try {
				getResource().getWorkerMap().remove(handlerID);
			} catch (Exception e) {
				throw Utils.newFault(new CancelTransferFault(), e);
			}
		}
		return handlerID;
	}
	
	
	@Override
	protected GCUBEServiceContext getServiceContext() {
		return ServiceContext.getContext();
	}

}