package org.gcube.datatransfer.agent.library.outcome;


/**
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class FileTransferOutcome extends TransferOutcome{

	private String filename;
	
	private String dest;
	
	private Long transferTime;

	public Long getTransferTime() {
		return transferTime;
	}


	public void setTransferTime(Long transferTime) {
		this.transferTime = transferTime;
	}


	public String getDest() {
		return dest;
	}


	public void setDest(String dest) {
		this.dest = dest;
	}


	/**
	 * Creates an instance with successfully added tree.
	 * @param tree the tree
	 */
	public FileTransferOutcome(String fileName) {
		this.filename=fileName;
	}

	
	/**
	 * Returns the successfully transfer a file.
	 * @return the tree, or <code>null</code> if the outcome indicates a failure
	 */
	public String fileName() {
		return filename;
	}
	

	
	@Override
	public String toString() {
		return isSuccess() ? fileName() : failure();
	}

	
	public String getFilename() {
		return filename;
	}


	public void setFilename(String filename) {
		this.filename = filename;
	}
}
