/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.library.calls;

import java.rmi.Remote;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.calls.GCUBECall;
import org.gcube.common.core.utils.calls.RICall;
import org.gcube.datatransfer.agent.library.calls.AgentServiceCallInterface;
import org.gcube.datatransfer.agent.stubs.datatransferagent.CancelTransferMessage;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DataTransferAgentPortType;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StartTransferMessage;
import org.gcube.datatransfer.agent.stubs.datatransferagent.service.DataTransferAgentServiceAddressingLocator;

public class AgentServiceCall
extends RICall
implements AgentServiceCallInterface {
    static int callTimeout = 240000;
    static String SERVICE_CLASS = "DataTransfer";
    static String SERVICE_NAME = "agent-service";

    public AgentServiceCall(GCUBEScope scope, GCUBESecurityManager[] securityManager) throws Exception {
        super(scope, securityManager);
    }

    @Override
    public String startTransfer(final StartTransferMessage message) throws Exception {
        final GCUBECall.ResultHolder result = new GCUBECall.ResultHolder();
        new RICall.RICallHandler(){

            public void interact(EndpointReferenceType epr) throws Exception {
                DataTransferAgentPortType PT = new DataTransferAgentServiceAddressingLocator().getDataTransferAgentPortTypePort(epr);
                PT = (DataTransferAgentPortType)GCUBERemotePortTypeContext.getProxy((Remote)PT, (GCUBEScopeManager)this.getScopeManager(), (int)callTimeout, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                result.value = PT.startTransfer(message);
            }

            protected List<EndpointReferenceType> findInstances() throws Exception {
                return AgentServiceCall.this.findPortType(AgentServiceCall.this.getRIQuery(), AgentServiceCall.this.getPortTypeName());
            }
        }.run();
        return (String)result.value;
    }

    @Override
    public String startLocalFileTransfer(final StartTransferMessage message) throws Exception {
        final GCUBECall.ResultHolder result = new GCUBECall.ResultHolder();
        new RICall.RICallHandler(){

            public void interact(EndpointReferenceType epr) throws Exception {
                DataTransferAgentPortType PT = new DataTransferAgentServiceAddressingLocator().getDataTransferAgentPortTypePort(epr);
                PT = (DataTransferAgentPortType)GCUBERemotePortTypeContext.getProxy((Remote)PT, (GCUBEScopeManager)this.getScopeManager(), (int)callTimeout, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                result.value = PT.startTransfer(message);
            }

            protected List<EndpointReferenceType> findInstances() throws Exception {
                return AgentServiceCall.this.findPortType(AgentServiceCall.this.getRIQuery(), AgentServiceCall.this.getPortTypeName());
            }
        }.run();
        return (String)result.value;
    }

    protected String getPortTypeName() {
        return "gcube/datatransfer/agent/DataTransferAgent";
    }

    protected String getServiceClass() {
        return SERVICE_CLASS;
    }

    protected String getServiceName() {
        return SERVICE_NAME;
    }

    protected GCUBERIQuery getRIQuery() throws Exception {
        GCUBERIQuery q = (GCUBERIQuery)((ISClient)GHNContext.getImplementation(ISClient.class)).getQuery(GCUBERIQuery.class);
        return q;
    }

    protected List<EndpointReferenceType> findPortType(GCUBERIQuery query, String portType) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        ArrayList<EndpointReferenceType> eprs = new ArrayList<EndpointReferenceType>();
        for (GCUBERunningInstance instance : client.execute((ISQuery)query, this.getScopeManager().getScope())) {
            if (instance.getAccessPoint().getEndpoint(portType) == null) continue;
            eprs.add(instance.getAccessPoint().getEndpoint(portType));
        }
        return eprs;
    }

    @Override
    public String cancelTransfer(final CancelTransferMessage message) throws Exception {
        final GCUBECall.ResultHolder result = new GCUBECall.ResultHolder();
        new RICall.RICallHandler(){

            public void interact(EndpointReferenceType epr) throws Exception {
                DataTransferAgentPortType PT = new DataTransferAgentServiceAddressingLocator().getDataTransferAgentPortTypePort(epr);
                PT = (DataTransferAgentPortType)GCUBERemotePortTypeContext.getProxy((Remote)PT, (GCUBEScopeManager)this.getScopeManager(), (int)callTimeout, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                result.value = PT.cancelTransfer(message);
            }

            protected List<EndpointReferenceType> findInstances() throws Exception {
                return AgentServiceCall.this.findPortType(AgentServiceCall.this.getRIQuery(), AgentServiceCall.this.getPortTypeName());
            }
        }.run();
        return (String)result.value;
    }
}

