/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.library.grs;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.File;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.gcube.datatransfer.agent.library.grs.FileRecord;

public class GRSFileWriter
extends Thread {
    private RecordWriter<GenericRecord> writer = null;
    private File[] files = null;

    public GRSFileWriter(IWriterProxy proxy, File[] files) throws GRS2WriterException {
        this.files = files;
        this.writer = new RecordWriter(proxy, FileRecord.fileRecordDef);
    }

    public URI getLocator() throws GRS2WriterException {
        return this.writer.getLocator();
    }

    @Override
    public void run() {
        for (File file : this.files) {
            if (file.isDirectory()) {
                System.out.println("File " + file + " is a directory and cannot be transferred");
                continue;
            }
            try {
                if (this.writer.getStatus() != IBuffer.Status.Open) {
                    return;
                }
                GenericRecord rec = new GenericRecord();
                rec.setFields(new Field[]{new FileField(file), new StringField(file.getName())});
                if (this.writer.put((Record)rec, 60L, TimeUnit.SECONDS)) continue;
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.writer.getStatus() != IBuffer.Status.Dispose) {
            try {
                this.writer.close();
            }
            catch (GRS2WriterException e) {
                e.printStackTrace();
            }
        }
    }

    public RecordWriter<GenericRecord> getWriter() {
        return this.writer;
    }

    public void setWriter(RecordWriter<GenericRecord> writer) {
        this.writer = writer;
    }
}

