/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.parser;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DarwinSimpleRecord {
    GCUBELog logger = new GCUBELog(DarwinSimpleRecord.class);
    public String occurrenceID;
    public Calendar modified;
    public Calendar eventTime;
    public String basisOfRecord;
    public String institutionCode;
    public String collectionID;
    public String collectionCode;
    public String catalogNumber;
    public String recordedBy;
    public String remarks;
    public String scientificName;
    public String scientificNameAuthorship;
    public String kingdom;
    public String phylum;
    public String clazz;
    public String order;
    public String family;
    public String genus;
    public String specificEpithet;
    public String infraspecificEpithet;
    public String authorYearOfScientificName;
    public String continent;
    public String country;
    public String locality;
    public String stateProvince;
    public int minimumElevationInMeters;
    public int maximumElevationInMeters;
    public int minimumDepthInMeters;
    public int maximumDepthInMeters;
    public String dayOfYear;
    public String collector;
    public String sex;
    public double decimalLatitude;
    public double decimalLongitude;
    public double verbatimLatitude;
    public double verbatimLongitude;
    public String identifiedBy;
    public String collectorNumber;
    public String fieldNumber;
    public String typeStatus;
    public String individualCount;
    public static SimpleDateFormat df = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");

    public DarwinSimpleRecord(Element eElement) {
        try {
            this.occurrenceID = this.getTagValue("dwc:occurrenceID", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.collectionID = this.getTagValue("dwc:collectionID", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.recordedBy = this.getTagValue("dwc:recordedBy", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.scientificNameAuthorship = this.getTagValue("dwc:scientificNameAuthorship", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.scientificName = this.getTagValue("dwc:scientificName", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.authorYearOfScientificName = this.getTagValue("dwc:authorYearOfScientificName", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.basisOfRecord = this.getTagValue("dwc:basisOfRecord", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.catalogNumber = this.getTagValue("dwc:catalogNumber", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.clazz = this.getTagValue("dwc:class", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.collectionCode = this.getTagValue("dwc:collectionCode", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.collector = this.getTagValue("dwc:collector", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.collectorNumber = this.getTagValue("dwc:collectorNumber", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.continent = this.getTagValue("dwc:continent", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.country = this.getTagValue("dwc:country", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        String modifiedDate = null;
        try {
            modifiedDate = this.getTagValue("dc:modified", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (modifiedDate != null) {
            this.modified = this.getCalendar(modifiedDate);
        }
        String eventTimeDate = null;
        try {
            eventTimeDate = this.getTagValue("dwc:eventDate", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (eventTimeDate != null) {
            this.eventTime = this.getCalendar(eventTimeDate);
        }
        try {
            this.dayOfYear = this.getTagValue("dwc:dayOfYear", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.family = this.getTagValue("dwc:family", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.fieldNumber = this.getTagValue("dwc:fieldNumber", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.genus = this.getTagValue("dwc:genus", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.identifiedBy = this.getTagValue("dwc:identifiedBy", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.individualCount = this.getTagValue("dwc:individualCount", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.infraspecificEpithet = this.getTagValue("dwc:infraspecificEpithet", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.institutionCode = this.getTagValue("dwc:institutionCode", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.kingdom = this.getTagValue("dwc:kingdom", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.locality = this.getTagValue("dwc:locality", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.order = this.getTagValue("dwc:order", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.phylum = this.getTagValue("dwc:phylum", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.remarks = this.getTagValue("dwc:remarks", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.sex = this.getTagValue("dwc:sex", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.specificEpithet = this.getTagValue("dwc:specificEpithet", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.stateProvince = this.getTagValue("dwc:stateProvince", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.typeStatus = this.getTagValue("dwc:typeStatus", eElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.decimalLatitude = Double.parseDouble(this.getTagValue("dwc:DecimalLatitude", eElement));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.decimalLongitude = Double.parseDouble(this.getTagValue("dwc:DecimalLongitude", eElement));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.maximumDepthInMeters = Integer.parseInt(this.getTagValue("dwc:MaximumDepthInMeters", eElement));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.maximumElevationInMeters = Integer.parseInt(this.getTagValue("dwc:MaximumElevationInMeters", eElement));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.minimumDepthInMeters = Integer.parseInt(this.getTagValue("dwc:MinimumDepthInMeters", eElement));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.minimumElevationInMeters = Integer.parseInt(this.getTagValue("dwc:MinimumElevationInMeters", eElement));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.verbatimLatitude = Double.parseDouble(this.getTagValue("dwc:VerbatimLatitude", eElement));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.verbatimLongitude = Double.parseDouble(this.getTagValue("dwc:VerbatimLongitude", eElement));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    private Calendar getCalendar(String myDate) {
        Calendar dateC = null;
        try {
            myDate = myDate.replace("T", " ");
            dateC = this.dateString2Calendar(myDate);
        }
        catch (ParseException e) {
            this.logger.error((Object)"ParseException", (Throwable)e);
        }
        return dateC;
    }

    private String getTagValue(String sTag, Element eElement) {
        Node nValue;
        NodeList textFNList;
        Element xmlNode;
        String a = "";
        NodeList nlList = eElement.getElementsByTagName(sTag);
        if (nlList != null && (xmlNode = (Element)nlList.item(0)) != null && (textFNList = xmlNode.getChildNodes()) != null && (nValue = textFNList.item(0)) != null) {
            a = nValue.getNodeValue();
        }
        return a;
    }

    private Calendar dateString2Calendar(String s) throws ParseException {
        Calendar cal = Calendar.getInstance();
        try {
            Date d1 = df.parse(s);
            cal.setTime(d1);
        }
        catch (Exception e) {
            return null;
        }
        return cal;
    }
}

