package org.gcube.data.spd.parser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DarwinRecord {
	
	GCUBELog logger = new GCUBELog(DarwinRecord.class);
	

	public int globalUniqueIdentifier;
	public Calendar dateLastModified;
	public String basisOfRecord;
	public String institutionCode;
	public String collectionCode;
	public String catalogNumber;
	public String remarks;
	public String scientificName;
	public String kingdom;
	public String phylum;
	public String clazz;
	public String order;
	public String family;
	public String genus;
	public String specificEpithet;
	public String infraspecificEpithet;
	public String authorYearOfScientificName;
	public String continent;
	public String country;
	public String locality;
	public String stateProvince;
	public int minimumElevationInMeters;
	public int maximumElevationInMeters;
	public int minimumDepthInMeters;
	public int maximumDepthInMeters;
	public String dayOfYear;
	public String collector;
	public String sex;
	public double decimalLatitude;
	public double decimalLongitude;
	public double verbatimLatitude;
	public double verbatimLongitude;
	public String identifiedBy;
	public String collectorNumber;
	public String fieldNumber;
	public String typeStatus;
	public String individualCount;
	public static SimpleDateFormat df=new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
	
	
	
	public DarwinRecord(Element eElement){
		
		this.globalUniqueIdentifier = Integer.parseInt(getTagValue("dwcore:GlobalUniqueIdentifier", eElement));
		this.scientificName = getTagValue("dwcore:ScientificName", eElement);
		this.authorYearOfScientificName = getTagValue("dwcore:AuthorYearOfScientificName", eElement);
//		System.out.println(getTagValue("dwcore:BasisOfRecord", eElement));
		
//		this.basisOfRecord = matchBasisOfRecord(getTagValue("dwcore:BasisOfRecord", eElement));
		this.basisOfRecord = getTagValue("dwcore:BasisOfRecord", eElement);
		this.catalogNumber = getTagValue("dwcore:CatalogNumber", eElement);
		this.clazz = getTagValue("dwcore:Class", eElement);
		this.collectionCode = getTagValue("dwcore:CollectionCode", eElement);
		this.collector = getTagValue("dwcore:Collector", eElement);
		this.collectorNumber = getTagValue("dwcur:CollectorNumber", eElement);
		this.continent = getTagValue("dwcore:Continent", eElement);
		this.country = getTagValue("dwcore:Country", eElement);
		
		//Calendar
		String dateL = getTagValue("dwcore:DateLastModified", eElement);
		
			try {
				if (dateL!=""){
					dateL = dateL.replace("T", " ");
				Calendar dateC = dateString2Calendar(dateL);
				this.dateLastModified = dateC;
				}
			} catch (ParseException e) {
				logger.error("ParseException" , e);
			}
		

		this.dayOfYear = getTagValue("dwcore:DayOfYear", eElement);
		this.family = getTagValue("dwcore:Family", eElement);
		this.fieldNumber = getTagValue("dwcur:FieldNumber", eElement);
		this.genus = getTagValue("dwcore:Genus", eElement);
		this.identifiedBy = getTagValue("dwcur:IdentifiedBy", eElement);
		this.individualCount = getTagValue("dwcur:IndividualCount", eElement);
		this.infraspecificEpithet = getTagValue("dwcore:InfraspecificEpithet", eElement);
		this.institutionCode = getTagValue("dwcore:InstitutionCode", eElement);
		this.kingdom = getTagValue("dwcore:Kingdom", eElement);
		this.locality = getTagValue("dwcore:Locality", eElement);
		this.order = getTagValue("dwcore:Order", eElement);
		this.phylum = getTagValue("dwcore:Phylum", eElement);
		this.remarks = getTagValue("dwcore:Remarks", eElement);
		this.sex = getTagValue("dwcore:Sex", eElement);
		this.specificEpithet = getTagValue("dwcore:SpecificEpithet", eElement);
		this.stateProvince = getTagValue("dwcore:StateProvince", eElement);
		this.typeStatus = getTagValue("dwcore:TypeStatus", eElement);
		
		try{ this.decimalLatitude = Double.parseDouble(getTagValue("dwgeo:DecimalLatitude", eElement));}		
		catch(NumberFormatException e) {}
		
		try{this.decimalLongitude = Double.parseDouble(getTagValue("dwgeo:DecimalLongitude", eElement));}
		catch(NumberFormatException e) {}
			
		try{this.maximumDepthInMeters = Integer.parseInt(getTagValue("dwcore:MaximumDepthInMeters", eElement));}
		catch(NumberFormatException e) {}
			
		try{this.maximumElevationInMeters = Integer.parseInt(getTagValue("dwcore:MaximumElevationInMeters", eElement));}
		catch(NumberFormatException e) {}
			
		try{this.minimumDepthInMeters = Integer.parseInt(getTagValue("dwcore:MinimumDepthInMeters", eElement));}
		catch(NumberFormatException e) {}
			
		try{this.minimumElevationInMeters = Integer.parseInt(getTagValue("dwcore:MinimumElevationInMeters", eElement));}
		catch(NumberFormatException e) {}
			
		try{this.verbatimLatitude = Double.parseDouble(getTagValue("dwgeo:VerbatimLatitude", eElement));}
		catch(NumberFormatException e) {}
						
		try{this.verbatimLongitude = Double.parseDouble(getTagValue("dwgeo:VerbatimLongitude", eElement));}
		catch(NumberFormatException e) {}

	}
	
	
	//Returns the tag value
	private String getTagValue(String sTag, Element eElement){	
		String a = "";

		//	NodeList nlList = eElement.getElementsByTagName(sTag).item(0).getChildNodes();
			
			NodeList nlList = eElement.getElementsByTagName(sTag);
			if (nlList!= null){	
				Element xmlNode = (Element)nlList.item(0);
				if (xmlNode != null){
					NodeList textFNList = xmlNode.getChildNodes();
					if (textFNList != null){
						Node nValue = (Node) textFNList.item(0);  
						if (nValue != null)						
							a = nValue.getNodeValue(); 				
					}
				}
			}
           // System.out.println(a);
		return a;
	}
	

	private Calendar dateString2Calendar(String s) throws ParseException {
	    Calendar cal=Calendar.getInstance();
	    try{
	    	Date d1=df.parse(s);
		    cal.setTime(d1);
	    }
		catch (Exception e) {
			return null;
		}
	    return cal;
	  }
	
}
