grammar SPQL;


@lexer::header {
package org.gcube.dataaccess.spql;
}

@header {
package org.gcube.dataaccess.spql;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import org.gcube.dataaccess.spql.model.*;
import static org.gcube.dataaccess.spql.model.ConditionParameter.*;
import static org.gcube.dataaccess.spql.model.TermType.*;
import static org.gcube.dataaccess.spql.model.ReturnType.*;
}

query returns [ParsingResult result] : {$result = new ParsingResult();}
      t=terms {$result.setTerms($t.termWords);} 
      (IN i=identifiers {$result.setPlugins($i.ids);})? 
      (WHERE e=expressions {$result.setConditions($e.conditions);})? 
      (RETURN r=returnExpression {$result.setReturnExpression($r.returnExpression);})?;
      
terms	returns [List<TermWords> termWords]: {$termWords = new ArrayList<TermWords>();} 
                                           t=term {$termWords.add($t.termWords);} (',' tr=term {$termWords.add($tr.termWords);})*;
term 	returns [TermWords termWords]: {$termWords = new TermWords();} 
                                     w=words {$termWords.setWords($w.words);} 
                                     AS
                                     ((('ScientificName'|'SN') {$termWords.setType(SCIENTIFIC_NAME);}) | (('CommonName'|'CN') {$termWords.setType(COMMON_NAME);}));

words	returns [List<String> words] : {$words = new ArrayList();}
	w=word {$words.add($w.word);} 
	(',' w=word {$words.add($w.word);})*;
	
word returns [String word] : STRING {$word = $STRING.text.substring(1,$STRING.text.length()-1);};

identifiers	returns [List<String> ids] :  {$ids = new ArrayList();}	
			id=identifier {$ids.add($id.id);} (',' id=identifier {$ids.add($id.id);})*;
			
identifier returns [String id]: ID {$id = $ID.text;};
			
expressions	returns [List<Condition> conditions]: {$conditions = new ArrayList<Condition>();} 
                                                  e=expression {$conditions.add($e.condition);} (AND er = expression {$conditions.add($er.condition);})*;
expression returns [Condition condition]:	(bc=boundCondition {$condition = $bc.condition;} | dc=dateCondition {$condition = $dc.condition;});

boundCondition returns [Condition condition]: {$condition = new Condition();} 
		('lowerBound' {$condition.setParameter(LOWER_BOUND);} | 'upperBound' {$condition.setParameter(UPPER_BOUND);})
		IS
		c=coordinate {$condition.setValue($c.coordinate);};
		
dateCondition	returns [Condition condition]: {$condition = new Condition();} 
		('fromDate' {$condition.setParameter(FROM_DATE);}  | 'toDate' {$condition.setParameter(TO_DATE);}) 
		IS 
		d=date {$condition.setValue($d.date);};
		
date returns [ParserDate date]:	f=INT '/' s=INT '/' t=INT {$date = new ParserDate($f.text,$s.text,$t.text);};

coordinate returns [ParserCoordinate coordinate]: lat=FLOAT ',' lon=FLOAT {$coordinate = new ParserCoordinate($lat.text, $lon.text);};

returnExpression returns [ReturnExpression returnExpression] :	{$returnExpression = new ReturnExpression();}
                        ('*' (he=havingExpression {$returnExpression.setHavingType($he.type);})? {$returnExpression.setType(ALL);} |
                        'Occurrence' {$returnExpression.setType(OCCURRENCE);} | 
                        'Taxon' {$returnExpression.setType(TAXON);});
havingExpression returns [Type type] : HAVING  
                        'Occurrence'  {$type = Type.OCCURRENCE;} | 
                        'Taxon' {$type = Type.TAXON;};

IN : 'in' | 'IN';
WHERE : 'where' | 'WHERE';
RETURN : 'return' | 'RETURN';
AND : 'and' | 'AND';
IS : 'is' | 'IS';
AS : 'as' | 'AS';
HAVING : 'having' | 'HAVING';

ID  :	('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'0'..'9'|'_')*
    ;

INT :	'0'..'9'+ ;


FLOAT
    :   ('0'..'9')+ '.' ('0'..'9')* EXPONENT?
    |   '.' ('0'..'9')+ EXPONENT?
    |   ('0'..'9')+ EXPONENT
    ;

COMMENT
    :   '//' ~('\n'|'\r')* '\r'? '\n' {$channel=HIDDEN;}
    |   '/*' ( options {greedy=false;} : . )* '*/' {$channel=HIDDEN;}
    ;

WS  :   ( ' '
        | '\t'
        | '\r'
        | '\n'
        ) {$channel=HIDDEN;}
    ;

STRING
    :  '\'' ( ESC_SEQ | ~('\\'|'\'') )* '\''
    ;
    	

fragment
EXPONENT : ('e'|'E') ('+'|'-')? ('0'..'9')+ ;

fragment
HEX_DIGIT : ('0'..'9'|'a'..'f'|'A'..'F') ;

fragment
ESC_SEQ
    :   '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\')
    |   UNICODE_ESC
    |   OCTAL_ESC
    ;

fragment
OCTAL_ESC
    :   '\\' ('0'..'3') ('0'..'7') ('0'..'7')
    |   '\\' ('0'..'7') ('0'..'7')
    |   '\\' ('0'..'7')
    ;

fragment
UNICODE_ESC
    :   '\\' 'u' HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT
    ;

