/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.specieslink;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.gcube.data.spd.plugin.fwk.Coordinate;
import org.gcube.data.spd.plugin.fwk.Property;

public class Utils {
    public static String credits;

    static String elaborateProps(Property[] properties) throws Exception {
        StringBuilder props = new StringBuilder();
        block6: for (Property prop : properties) {
            switch (prop.getProp()) {
                case CoordinateFrom: {
                    Coordinate coordFrom = (Coordinate)prop.getValue();
                    props.append("%20and%20http://rs.tdwg.org/dwc/geospatial/DecimalLatitude%20greaterThanOrEquals%20%22" + coordFrom.getLatitude() + "%22");
                    props.append("%20and%20http://rs.tdwg.org/dwc/geospatial/DecimalLongitude%20greaterThanOrEquals%20%22" + coordFrom.getLongitude() + "%22");
                    continue block6;
                }
                case CoordinateTo: {
                    Coordinate coordTo = (Coordinate)prop.getValue();
                    props.append("%20and%20http://rs.tdwg.org/dwc/geospatial/DecimalLatitude%20lessThanOrEqual%20%22" + coordTo.getLatitude() + "%22");
                    props.append("%20and%20http://rs.tdwg.org/dwc/geospatial/DecimalLongitude%20lessThanOrEqual%20%22" + coordTo.getLongitude() + "%22");
                    continue block6;
                }
                case DateFrom: {
                    Calendar dateFrom = (Calendar)prop.getValue();
                    SimpleDateFormat dfFrom = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                    props.append("%20and%20http://rs.tdwg.org/dwc/dwcore/DateLastModified%20greaterThanOrEquals%20%22" + dfFrom.format(dateFrom.getTime()) + "%22");
                    continue block6;
                }
                case DateTo: {
                    Calendar dateTo = (Calendar)prop.getValue();
                    SimpleDateFormat dfTo = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                    props.append("%20and%20http://rs.tdwg.org/dwc/dwcore/DateLastModified%20lessThanOrEquals%20%22" + dfTo.format(dateTo.getTime()) + "%22");
                    continue block6;
                }
            }
        }
        return props.toString();
    }

    public static String credits() {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String credits = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with speciesLink (http://splink.cria.org.br/)".replace("XDATEX", format.format(now.getTime()));
        return credits;
    }

    public static String citation() {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String citation = "Accessed through: speciesLink at http://splink.cria.org.br/ on XDATEX".replace("XDATEX", format.format(now.getTime()));
        return citation;
    }
}

