package org.gcube.data.spd.specieslink;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.parser.DarwinRecord;
import org.gcube.data.spd.parser.RecordsIterator;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.exceptions.StreamBlockingException;
import org.gcube.data.spd.plugin.fwk.model.BasisOfRecord;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;



public class OccurrencesCapabilityImpl extends OccurrencesCapability {

	GCUBELog logger = new GCUBELog(OccurrencesCapabilityImpl.class);

	@SuppressWarnings("serial")
	public Set<Properties> getSupportedProperties() {
		return new HashSet<Properties>() {{
			add(Properties.DateFrom);
			add(Properties.DateTo);
			add(Properties.CoordinateFrom);
			add(Properties.CoordinateTo);
		}};
	}

	private static BasisOfRecord matchBasisOfRecord(String value){
		for (BasisOfRecord record: BasisOfRecord.values())
			if (record.name().toLowerCase().equals(value.toLowerCase())) return record;
		if (value.toLowerCase().equals("S".toLowerCase())) return BasisOfRecord.PreservedSpecimen;
		else if (value.toLowerCase().equals("Fotot".toLowerCase())) return BasisOfRecord.MachineObservation;

		return BasisOfRecord.HumanObservation;
	}


	@Override
	public void searchByCommonName(String word,
			ObjectWriter<OccurrencePoint> writer, Property... properties) {

	}

	@Override
	public void searchByScientificName(String scientificName,
			ObjectWriter<OccurrencePoint> writer, Property... properties) {
		logger.trace("searchByScientificName " + scientificName + " in SpeciesLink");
		String f = "";
		try {
			f = Utils.elaborateProps(properties);
		} catch (Exception e) {
			logger.error("error elaborating properties",e);
			writer.close();
			return;
		}

		String filter = "http://rs.tdwg.org/dwc/dwcore/ScientificName%20like%20%22" + scientificName.replace(" ", "%20") + "%22" + f + "&orderBy=http://rs.tdwg.org/dwc/dwcore/ScientificName&orderBy=http://rs.tdwg.org/dwc/dwcore/InstitutionCode";

		RecordsIterator set = new RecordsIterator(SpeciesLinkPlugin.baseurl, filter, SpeciesLinkPlugin.model);
		Iterator<DarwinRecord> it = set.iterator();

		DarwinRecord element = null;		
		try{
			while (it.hasNext()) 
			{
				element = it.next();
				OccurrencePoint a = new OccurrencePoint(element.globalUniqueIdentifier+"");

				a.setBasisOfRecord(matchBasisOfRecord((element.basisOfRecord)));
				a.setCatalogueNumber(element.catalogNumber);
				a.setCitation(element.identifiedBy);
				a.setCollectionCode(element.collectionCode);
				a.setCountry(element.country);
				a.setDecimalLatitude(element.decimalLatitude);
				a.setDecimalLongitude(element.decimalLongitude);
				a.setEventDate(null);
				a.setFamily(element.family);
				a.setInstitutionCode(element.institutionCode);
				a.setKingdom(element.kingdom);
				a.setLocality(element.country);
				a.setMaxDepth(element.maximumDepthInMeters);
				a.setMinDepth(element.minimumDepthInMeters);
				a.setModified(element.dateLastModified);
				a.setRecordedBy(element.identifiedBy);
				a.setScientificName(element.scientificName);		
				a.setCredits(Utils.credits());
				a.setCitation(Utils.citation());
				if ((a!=null) && (writer.isAlive()))
					writer.write(a);
				else
					break;

			}

		}catch (Exception e) {
			logger.error("General Error", e);
			writer.write(new StreamBlockingException());
			
		}finally{
			writer.close();
		}

	}

	@Override
	public void getOccurrencesByIds(ObjectWriter<OccurrencePoint> writer,
			Iterator<String> ids) {
		try{
			while(ids.hasNext()) {

				String id = ids.next(); 
				logger.trace("getOccurrencesByIds " + id + " in SpeciesLink");

				String filter = "http://rs.tdwg.org/dwc/dwcore/GlobalUniqueIdentifier%20equals%20%22" + id + "%22";

				RecordsIterator set = new RecordsIterator(SpeciesLinkPlugin.baseurl, filter, SpeciesLinkPlugin.model);
				Iterator<DarwinRecord> it = set.iterator();

				DarwinRecord element = null;		

				while (it.hasNext()){

					element = it.next();

					OccurrencePoint a = new OccurrencePoint(id);

					a.setBasisOfRecord(matchBasisOfRecord((element.basisOfRecord)));
					a.setCatalogueNumber(element.catalogNumber);
					a.setCitation(element.identifiedBy);
					a.setCollectionCode(element.collectionCode);
					a.setCountry(element.country);
					a.setDecimalLatitude(element.decimalLatitude);
					a.setDecimalLongitude(element.decimalLongitude);
					a.setEventDate(null);
					a.setFamily(element.family);
					a.setInstitutionCode(element.institutionCode);
					a.setKingdom(element.kingdom);
					a.setLocality(element.country);
					a.setMaxDepth(element.maximumDepthInMeters);
					a.setMinDepth(element.minimumDepthInMeters);
					a.setModified(element.dateLastModified);
					a.setRecordedBy(element.identifiedBy);
					a.setScientificName(element.scientificName);		
					a.setCredits(Utils.credits());
					a.setCitation(Utils.citation());
					if ((a!=null) && (writer.isAlive()))
						writer.write(a);
					else
						break;
				}
			}
		}catch (Exception e) {
			logger.error("General Error", e);
			writer.write(new StreamBlockingException());
		}finally{
			writer.close();
		}

	}

	@Override
	public void getOccurrencesByProductKeys(ObjectWriter<OccurrencePoint> writer,
			Iterator<String> keys) {
		try{
			while(keys.hasNext()) {

				String key = keys.next(); 
				logger.trace("getOccurrencesByProductKeys " + key + " in SpeciesLink");


				RecordsIterator set = new RecordsIterator(SpeciesLinkPlugin.baseurl, key, SpeciesLinkPlugin.model);
				Iterator<DarwinRecord> it = set.iterator();

				DarwinRecord element = null;		

				while (it.hasNext()) 
				{
					element = it.next();

				
					OccurrencePoint a = new OccurrencePoint(element.globalUniqueIdentifier+"");

					a.setBasisOfRecord(matchBasisOfRecord((element.basisOfRecord)));
					a.setCatalogueNumber(element.catalogNumber);
					a.setCitation(element.identifiedBy);
					a.setCollectionCode(element.collectionCode);
					a.setCountry(element.country);
					a.setDecimalLatitude(element.decimalLatitude);
					a.setDecimalLongitude(element.decimalLongitude);
					a.setEventDate(null);
					a.setFamily(element.family);
					a.setInstitutionCode(element.institutionCode);
					a.setKingdom(element.kingdom);
					a.setLocality(element.country);
					a.setMaxDepth(element.maximumDepthInMeters);
					a.setMinDepth(element.minimumDepthInMeters);
					a.setModified(element.dateLastModified);
					a.setRecordedBy(element.identifiedBy);
					a.setScientificName(element.scientificName);		
					a.setCredits(Utils.credits());
					a.setCitation(Utils.citation());
					if ((a!=null) && (writer.isAlive()))
						writer.write(a);
					else
						break;
				}

			}
		}catch (Exception e) {
			logger.error("General Error", e);
			writer.write(new StreamBlockingException());
		}finally{
			writer.close();
		}

	}


}
