package org.gcube.data.spd.model.service;

import java.rmi.RemoteException;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.gcube.data.spd.model.service.exceptions.InvalidIdentifierException;
import org.gcube.data.spd.model.service.types.PluginDescriptions;
import org.gcube.data.spd.model.service.types.SearchRequest;

@WebService(name=Constants.remoteDispatcher_portType,targetNamespace=Constants.remoteDispatcher_target_namespace)
public interface RemoteDispatcher {

	@SOAPBinding(parameterStyle=ParameterStyle.BARE)	
	String search(SearchRequest request) throws RemoteException;

	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)	
	String getSynonymsById(String id, String pluginName)
			throws RemoteException, InvalidIdentifierException;

	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)	
	String retrieveTaxonChildrenByTaxonId(String id,
			String pluginName) throws RemoteException,
			InvalidIdentifierException;

	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)	
	String retrieveTaxaByIds(String idsLocator,
			String pluginName) throws RemoteException;

	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)	
	String getTaxonById(String id, String pluginName)
			throws RemoteException, InvalidIdentifierException;

	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)	
	String getOccurrencesByProductKeys(
			String productKeysLocator, String pluginName)
					throws RemoteException;

	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)	
	String getOccurrencesByIds(String idsLocator,
			String pluginName) throws RemoteException;

	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)	
	String namesMapping(String commonName, String pluginName)
			throws RemoteException;

	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)	
	String expandWithSynonyms(String scientificName,
			String pluginName) throws RemoteException;

	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)	
	String unfold(String scientificName, String pluginName)
			throws RemoteException;

	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)	
	PluginDescriptions exchangePlugins(PluginDescriptions localPlugins, String gCoreEndpointId) 
			throws RemoteException;

	@SOAPBinding(parameterStyle=ParameterStyle.BARE)	
	void removeAll(String gCoreEndpointId) throws RemoteException;
	
}