/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.model;

import java.util.Calendar;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.Coordinate;

public class Condition
implements Comparable<Condition> {
    Object value;
    Conditions cond;
    Operator op;

    public Condition(Conditions cond, Object value, Operator op) {
        this.value = value;
        this.cond = cond;
        this.op = op;
    }

    public boolean isValid() {
        return this.cond.getType().equals(this.value.getClass());
    }

    public Object getValue() {
        return this.value;
    }

    public Operator getOp() {
        return this.op;
    }

    public Conditions getType() {
        return this.cond;
    }

    @Override
    public int compareTo(Condition o) {
        if (o.equals(this)) {
            return 0;
        }
        if (o.getType() != this.getType()) {
            return o.getType().compareTo(this.getType());
        }
        if (o.getOp() != this.getOp()) {
            return o.getOp().compareTo(this.getOp());
        }
        switch (this.getType()) {
            case DATE: {
                return ((Calendar)this.getValue()).compareTo((Calendar)o.getValue());
            }
            case COORDINATE: {
                return ((Coordinate)this.getValue()).compareTo((Coordinate)o.getValue());
            }
        }
        return 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cond == null ? 0 : this.cond.hashCode());
        result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Condition other = (Condition)obj;
        if (this.cond != other.cond) {
            return false;
        }
        if (this.op != other.op) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static enum Operator {
        GE,
        GT,
        LE,
        LT,
        EQ;

    }
}

