/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.client.proxies;

import com.thoughtworks.xstream.XStream;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils;
import org.gcube.data.spd.client.proxies.DefaultResultSet;
import org.gcube.data.spd.client.proxies.ExecutorClient;
import org.gcube.data.spd.model.service.exceptions.InvalidIdentifierException;
import org.gcube.data.spd.model.service.types.CompleteJobStatus;
import org.gcube.data.spd.model.service.types.JobType;
import org.gcube.data.spd.model.service.types.MetadataDetails;
import org.gcube.data.spd.model.service.types.SubmitJob;
import org.gcube.data.spd.model.service.types.SubmitJobResponse;
import org.gcube.data.streams.Stream;

public class DefaultExecutor
implements ExecutorClient {
    private final ProxyDelegate<WebTarget> delegate;

    public DefaultExecutor(ProxyDelegate<WebTarget> delegate) {
        this.delegate = delegate;
    }

    private Call<WebTarget, SubmitJobResponse> getCallForJobs(final String input, final JobType job) {
        Call<WebTarget, SubmitJobResponse> call = new Call<WebTarget, SubmitJobResponse>(){

            public SubmitJobResponse call(WebTarget executor) throws Exception {
                SubmitJob jobRequest = new SubmitJob(input, job);
                return (SubmitJobResponse)executor.path("execute").request().post(Entity.xml((Object)jobRequest), SubmitJobResponse.class);
            }
        };
        return call;
    }

    @Override
    public String getErrorLink(final String jobId) throws InvalidIdentifierException {
        Call<WebTarget, String> call = new Call<WebTarget, String>(){

            public String call(WebTarget executor) throws Exception {
                return (String)executor.path("error").path(jobId).request().get(String.class);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new InvalidIdentifierException();
        }
    }

    @Override
    public String getResultLink(final String jobId) throws InvalidIdentifierException {
        Call<WebTarget, String> call = new Call<WebTarget, String>(){

            public String call(WebTarget executor) throws Exception {
                return (String)executor.path("result").path(jobId).request().get(String.class);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new InvalidIdentifierException();
        }
    }

    @Override
    public CompleteJobStatus getStatus(final String jobId) throws InvalidIdentifierException {
        Call<WebTarget, CompleteJobStatus> call = new Call<WebTarget, CompleteJobStatus>(){

            public CompleteJobStatus call(WebTarget executor) throws Exception {
                return (CompleteJobStatus)executor.path("status").path(jobId).request().get(CompleteJobStatus.class);
            }
        };
        try {
            return (CompleteJobStatus)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new InvalidIdentifierException();
        }
    }

    @Override
    public void removeJob(final String jobId) throws InvalidIdentifierException {
        Call<WebTarget, JAXWSUtils.Empty> call = new Call<WebTarget, JAXWSUtils.Empty>(){

            public JAXWSUtils.Empty call(WebTarget executor) throws Exception {
                executor.path(jobId).request().delete();
                return new JAXWSUtils.Empty();
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new InvalidIdentifierException();
        }
    }

    @Override
    public String createDwCAByChildren(String taxonKey) throws Exception {
        return ((SubmitJobResponse)this.delegate.make(this.getCallForJobs(taxonKey, JobType.DWCAByChildren))).getJobId();
    }

    @Override
    public String createDwCAByIds(Stream<String> ids) throws Exception {
        SubmitJobResponse response = (SubmitJobResponse)this.delegate.make(this.getCallForJobs(null, JobType.DWCAById));
        try {
            DefaultResultSet.sendInput(response.getEndpointId(), response.getInputLocator(), ids);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response.getJobId();
    }

    @Override
    public String createCSV(Stream<String> ids) throws Exception {
        SubmitJobResponse response = (SubmitJobResponse)this.delegate.make(this.getCallForJobs(null, JobType.CSV));
        try {
            DefaultResultSet.sendInput(response.getEndpointId(), response.getInputLocator(), ids);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response.getJobId();
    }

    @Override
    public String createLayer(Stream<String> keys, MetadataDetails metadata) throws Exception {
        SubmitJobResponse response = (SubmitJobResponse)this.delegate.make(this.getCallForJobs(new XStream().toXML((Object)metadata), JobType.LayerCreator));
        try {
            DefaultResultSet.sendInput(response.getEndpointId(), response.getInputLocator(), keys);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response.getJobId();
    }

    @Override
    public String createCSVforOM(Stream<String> ids) throws Exception {
        SubmitJobResponse response = (SubmitJobResponse)this.delegate.make(this.getCallForJobs(null, JobType.CSVForOM));
        try {
            DefaultResultSet.sendInput(response.getEndpointId(), response.getInputLocator(), ids);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response.getJobId();
    }

    @Override
    public String createDarwincoreFromOccurrenceKeys(Stream<String> ids) throws Exception {
        SubmitJobResponse response = (SubmitJobResponse)this.delegate.make(this.getCallForJobs(null, JobType.DarwinCore));
        try {
            DefaultResultSet.sendInput(response.getEndpointId(), response.getInputLocator(), ids);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response.getJobId();
    }
}

