package org.gcube.data.spd.client.proxies;

import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.glassfish.jersey.client.ChunkedInput;

public class DefaultResultSet implements ResultSetClient {

	private final ProxyDelegate<WebTarget> delegate;
		
	public DefaultResultSet(ProxyDelegate<WebTarget> config){
		this.delegate = config;
	}

	@Override
	public ChunkedInput<String> getResultSet(final String locator){
		Call<WebTarget, ChunkedInput<String>> call = new Call<WebTarget, ChunkedInput<String>>() {
			@Override
			public ChunkedInput<String> call(WebTarget manager) throws Exception {
				return  manager.path(locator).request().get(new GenericType<ChunkedInput<String>>() {});
			}
		};
		try {
			return delegate.make(call);
		
		}catch(Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	@Override
	public void closeResultSet(final String locator){
		Call<WebTarget, Empty> call = new Call<WebTarget, Empty>() {
			@Override
			public Empty call(WebTarget manager) throws Exception {
				 manager.path(locator).request().delete();
				 return new Empty();
			}
		};
		try {
			delegate.make(call);
		}catch(Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	

}
