package org.gcube.data.spd.client.proxies;

import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.data.spd.client.ResultElementRecordIterator;
import org.gcube.data.spd.client.ResultLocator;
import org.gcube.data.spd.client.Utils;
import org.gcube.data.spd.model.PointInfo;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;

public class DefaultOccurrence implements OccurrenceClient {

	private final ProxyDelegate<WebTarget> delegate;

	public DefaultOccurrence(ProxyDelegate<WebTarget> config){
		this.delegate = config;
	}

	@Override
	public Stream<OccurrencePoint> getByIds(final List<String> ids) {
		Call<WebTarget, ResultLocator> call = new Call<WebTarget, ResultLocator>() {
			@Override
			public ResultLocator call(WebTarget manager) throws Exception {
				manager = manager.path("ids");
				for (String value: ids)
					manager = manager.queryParam("ids", value);
				System.out.println(manager.getUri().toString());
				Response response = manager.request().get(Response.class);			
				String host = manager.getUri().getHost();
				int port = manager.getUri().getPort();
				return new ResultLocator(host, port, Utils.getLocatorFromResponse(response));
			}
		};
		try {
			ResultLocator result = delegate.make(call);
			ResultElementRecordIterator<OccurrencePoint> ri = new ResultElementRecordIterator<OccurrencePoint>(result, 2, TimeUnit.MINUTES);

			return Streams.convert(ri);
		}catch(Exception e) {
			throw new RuntimeException(e);
		}

	}

	@Override
	public Stream<OccurrencePoint> getByKeys(final List<String> keys) {
		Call<WebTarget, ResultLocator> call = new Call<WebTarget, ResultLocator>() {
			@Override
			public ResultLocator call(WebTarget manager) throws Exception {
				manager = manager.path("keys");
				for (String value: keys)
					manager = manager.queryParam("keys", value);
				Response response = manager.request().get(Response.class);
				String host = manager.getUri().getHost();
				int port = manager.getUri().getPort();
				return new ResultLocator(host, port, Utils.getLocatorFromResponse(response));
			}
		};
		try {
			ResultLocator result = delegate.make(call);
			ResultElementRecordIterator<OccurrencePoint> ri = new ResultElementRecordIterator<OccurrencePoint>(result, 2, TimeUnit.MINUTES);
			return Streams.convert(ri);
		}catch(Exception e) {
			throw new RuntimeException(e);
		}

	}
	/*
	@Override
	public String createLayer(Stream<PointInfo> coordinatesStream) {
		Stream<String> convertedStream = pipe(coordinatesStream).through(new Generator<PointInfo, String>() {

			@Override
			public String yield(PointInfo element) {
				try {
					return Bindings.toXml(element);
				} catch (Exception e) {
					throw new StreamSkipSignal();
				}
			}

		});

		final String coordinateLocator = publishStringsIn(convertedStream).withDefaults().toString();

		Call<OccurrenceStubs, String> call = new Call<OccurrenceStubs, String>() {
			@Override
			public String call(OccurrenceStubs occurrence) throws Exception {
				return occurrence.createLayer(coordinateLocator);
			}
		};

		try {
			return delegate.make(call);
		}catch(Exception e) {
			throw again(e).asServiceException();
		}	
	}
	 */

	@Override
	public String createLayer(Stream<PointInfo> coordinatesLocator) {
		// TODO Auto-generated method stub
		return null;
	}


}
