/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.client.proxies;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils;
import org.gcube.data.spd.client.proxies.Executor;
import org.gcube.data.spd.stubs.ExecutorStub;
import org.gcube.data.spd.stubs.exceptions.InvalidIdentifierException;
import org.gcube.data.spd.stubs.types.JobType;
import org.gcube.data.spd.stubs.types.Status;
import org.gcube.data.spd.stubs.types.SubmitJob;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;

public class DefaultExecutor
implements Executor {
    private final ProxyDelegate<ExecutorStub> delegate;

    public DefaultExecutor(ProxyDelegate<ExecutorStub> delegate) {
        this.delegate = delegate;
    }

    @Override
    public String createDwCAByChildren(String taxonKey) throws Exception {
        return (String)this.delegate.make(this.getCallForJobs(taxonKey, JobType.DWCAByChildren));
    }

    @Override
    public String createDwCAByIds(Stream<String> ids) throws Exception {
        String idsLocator = Streams.publishStringsIn(ids).withDefaults().toString();
        return (String)this.delegate.make(this.getCallForJobs(idsLocator, JobType.DWCAById));
    }

    @Override
    public String createCSV(Stream<String> keys) throws Exception {
        String idsLocator = Streams.publishStringsIn(keys).withDefaults().toString();
        return (String)this.delegate.make(this.getCallForJobs(idsLocator, JobType.CSV));
    }

    @Override
    public String createCSVforOM(Stream<String> keys) throws Exception {
        String idsLocator = Streams.publishStringsIn(keys).withDefaults().toString();
        return (String)this.delegate.make(this.getCallForJobs(idsLocator, JobType.CSVForOM));
    }

    @Override
    public String createDarwincoreFromOccurrenceKeys(Stream<String> keys) throws Exception {
        String idsLocator = Streams.publishStringsIn(keys).withDefaults().toString();
        return (String)this.delegate.make(this.getCallForJobs(idsLocator, JobType.DarwinCore));
    }

    @Override
    public String getResultLink(final String jobId) throws InvalidIdentifierException {
        Call<ExecutorStub, String> call = new Call<ExecutorStub, String>(){

            public String call(ExecutorStub executor) throws Exception {
                return executor.getResultLink(jobId);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public Status getStatus(final String jobId) throws InvalidIdentifierException {
        Call<ExecutorStub, Status> call = new Call<ExecutorStub, Status>(){

            public Status call(ExecutorStub executor) throws Exception {
                return executor.getStatus(jobId);
            }
        };
        try {
            return (Status)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public void removeJob(final String jobId) throws InvalidIdentifierException {
        Call<ExecutorStub, JAXWSUtils.Empty> call = new Call<ExecutorStub, JAXWSUtils.Empty>(){

            public JAXWSUtils.Empty call(ExecutorStub executor) throws Exception {
                return executor.removeJob(jobId);
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    private Call<ExecutorStub, String> getCallForJobs(final String input, final JobType job) {
        return new Call<ExecutorStub, String>(){

            public String call(ExecutorStub executor) throws Exception {
                return executor.submitJob(new SubmitJob(input, job));
            }
        };
    }

    @Override
    public String getErrorLink(final String jobId) throws InvalidIdentifierException {
        Call<ExecutorStub, String> call = new Call<ExecutorStub, String>(){

            public String call(ExecutorStub executor) throws Exception {
                return executor.getResultLink(jobId);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

