package org.gcube.data.spd.client.proxies;

import static org.gcube.common.clients.exceptions.FaultDSL.again;
import static org.gcube.data.streams.dsl.Streams.convert;
import static org.gcube.data.streams.dsl.Streams.pipe;
import static org.gcube.data.streams.dsl.Streams.publishStringsIn;
import gr.uoa.di.madgik.grs.record.GenericRecord;

import java.io.File;
import java.net.URI;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
//import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.client.ResultGenerator;
import org.gcube.data.spd.client.formats.MapDwCA;
import org.gcube.data.spd.plugin.fwk.exceptions.IdNotValidException;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.stubs.ClassificationPortType;
import org.gcube.data.streams.Stream;

public class DefaultClassification implements Classification{

	private final ProxyDelegate<ClassificationPortType> delegate;
	
	private final ResultGenerator<TaxonomyItem> taxonItemGenerator = new ResultGenerator<TaxonomyItem>();
	
	//private static GCUBELog logger = new GCUBELog(DefaultClassification.class);
	
	public DefaultClassification(ProxyDelegate<ClassificationPortType> config){
		this.delegate = config;
	}
	
	@Override
	public Stream<TaxonomyItem> getTaxonChildsById(final String id){
		
		Call<ClassificationPortType, URI> call = new Call<ClassificationPortType, URI>() {
			@Override
			public URI call(ClassificationPortType classificationPT) throws Exception {
				return new URI(classificationPT.retrieveTaxonChildsByTaxonId(id));
			}
		};
		try {
			return pipe(convert(delegate.make(call)).of(GenericRecord.class).withDefaults()).through(taxonItemGenerator);
		}catch(Exception e) {
			throw again(e).asServiceException();
		}
	}

	@Override
	public Stream<TaxonomyItem> getTaxonByIds(final Stream<String> ids) {
		final String idsLocator = publishStringsIn(ids).withDefaults().toString();
		Call<ClassificationPortType, URI> call = new Call<ClassificationPortType, URI>() {
			@Override
			public URI call(ClassificationPortType classificationPT) throws Exception {
				return new URI(classificationPT.getTaxonByIds(idsLocator));
			}
		};
		try {
			return pipe(convert(delegate.make(call)).of(GenericRecord.class).withDefaults()).through(taxonItemGenerator);
		}catch(Exception e) {
			throw again(e).asServiceException();
		}
	}

	@Override
	public File getDarwinCoreArchive(Stream<String> taxonIds) throws Exception {
		return new MapDwCA().createDwCA(taxonIds);
	}

	@Override
	public Stream<TaxonomyItem> getTaxonTreeById(final String id)
			throws IdNotValidException, Exception {
		Call<ClassificationPortType, URI> call = new Call<ClassificationPortType, URI>() {
			@Override
			public URI call(ClassificationPortType classificationPT) throws Exception {
				return new URI(classificationPT.retrieveChildrenTreeById(id));
			}
		};
		try {
			return pipe(convert(delegate.make(call)).of(GenericRecord.class).withDefaults()).through(taxonItemGenerator);
		}catch(Exception e) {
			throw again(e).asServiceException();
		}
	}
	
	
	
}
