/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.search.query;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.gcube.data.spd.obisplugin.search.query.QueryCondition;
import org.gcube.data.spd.obisplugin.search.query.ResultType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagedQueryObject {
    private static final Logger log = LoggerFactory.getLogger(PagedQueryObject.class);
    @NonNull
    private String baseUri;
    List<QueryCondition> conditions = new ArrayList<QueryCondition>();
    @NonNull
    private ResultType resultType;
    @NonNull
    private Integer resultPerQuery;
    private String after = null;
    private Integer pageCount = 0;

    public void setConditions(QueryCondition ... conditions) {
        this.conditions.addAll(Arrays.asList(conditions));
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public Integer getPageCount() {
        return this.pageCount;
    }

    public String buildNext() {
        StringBuilder query = new StringBuilder(this.baseUri);
        if (!this.baseUri.endsWith("/")) {
            query.append("/");
        }
        query.append(this.resultType.getQueryEntry()).append("/");
        query.append("?size=").append(this.resultPerQuery);
        if (this.after != null) {
            query.append("&after=").append(this.after);
        }
        this.pageCount = this.pageCount + this.resultPerQuery;
        if (this.conditions.size() > 0) {
            for (QueryCondition queryCond : this.conditions) {
                query.append("&").append(queryCond.getKey()).append("=").append(queryCond.getValue());
            }
        }
        log.debug("executed query is " + query.toString());
        return query.toString();
    }

    @ConstructorProperties(value={"baseUri", "resultType", "resultPerQuery"})
    public PagedQueryObject(@NonNull String baseUri, @NonNull ResultType resultType, @NonNull Integer resultPerQuery) {
        if (baseUri == null) {
            throw new NullPointerException("baseUri");
        }
        if (resultType == null) {
            throw new NullPointerException("resultType");
        }
        if (resultPerQuery == null) {
            throw new NullPointerException("resultPerQuery");
        }
        this.baseUri = baseUri;
        this.resultType = resultType;
        this.resultPerQuery = resultPerQuery;
    }

    public List<QueryCondition> getConditions() {
        return this.conditions;
    }
}

