/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.search.query;

import java.util.Iterator;
import java.util.Map;
import lombok.NonNull;
import org.gcube.data.spd.obisplugin.search.query.MappingUtils;
import org.gcube.data.spd.obisplugin.search.query.PagedQueryObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PagedQueryIterator<T>
implements Iterator<T> {
    private static Logger log = LoggerFactory.getLogger(PagedQueryIterator.class);
    @NonNull
    private PagedQueryObject pagedQuery;
    Map<String, Object> mapping;
    Iterator<Map<String, Object>> resultIterator;
    Map<String, Object> actualObject = null;
    Long start = null;
    Long parsingStart = null;

    public PagedQueryIterator(@NonNull PagedQueryObject pagedQuery) {
        if (pagedQuery == null) {
            throw new NullPointerException("pagedQuery");
        }
        this.pagedQuery = pagedQuery;
    }

    protected abstract T getObject(Map<String, Object> var1) throws Exception;

    @Override
    public boolean hasNext() {
        try {
            if (this.resultIterator == null) {
                String query = this.pagedQuery.buildNext();
                this.start = System.currentTimeMillis();
                this.mapping = MappingUtils.getObjectMapping(query);
                if (this.mapping.get("results") == null) {
                    return false;
                }
                this.parsingStart = System.currentTimeMillis();
                log.trace("[Benchmark] got Elements with query " + query + " and took " + (this.parsingStart - this.start));
                this.resultIterator = ((Iterable)this.mapping.get("results")).iterator();
            }
            if (!this.resultIterator.hasNext()) {
                log.trace("[Benchmark] page retrieved and parsed in " + (System.currentTimeMillis() - this.start));
                if (((Boolean)this.mapping.get("lastpage")).booleanValue()) {
                    log.trace("is end of records, no next element");
                    return false;
                }
                this.resultIterator = null;
            } else {
                this.actualObject = this.resultIterator.next();
                if (this.useIt(this.actualObject)) {
                    return true;
                }
            }
            return this.hasNext();
        }
        catch (Exception e) {
            log.error("error computing hasNext", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public T next() {
        try {
            return this.getObject(this.actualObject);
        }
        catch (Exception e) {
            log.error("error computing next", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected boolean useIt(Map<String, Object> mappedObject) {
        return true;
    }

    @Override
    public void remove() {
        this.resultIterator = null;
    }
}

