/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.search;

import java.util.List;
import java.util.Map;
import org.gcube.data.spd.model.products.DataProvider;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.obisplugin.search.query.MappingUtils;
import org.gcube.data.spd.obisplugin.search.query.QueryByIdentifier;
import org.gcube.data.spd.obisplugin.search.query.QueryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetRetreiver {
    private static Logger log = LoggerFactory.getLogger(DataSetRetreiver.class);

    public static DataSet get(String key, String baseURL) throws Exception {
        List institutionMapping;
        long start = System.currentTimeMillis();
        QueryByIdentifier datasetQuery = new QueryByIdentifier(baseURL, key, QueryType.Dataset);
        Map<String, Object> mapping = MappingUtils.getObjectMapping(datasetQuery.build());
        DataSet dataset = new DataSet(key);
        dataset.setName(MappingUtils.getAsString(mapping, "name"));
        String citation = MappingUtils.getAsString(mapping, "citation");
        if (citation == null && (institutionMapping = (List)mapping.get("institutes")).size() > 0) {
            if (MappingUtils.getAsString((Map)institutionMapping.get(0), "parent") != null) {
                citation = citation + " - " + MappingUtils.getAsString((Map)institutionMapping.get(0), "parent");
            }
            dataset.setCitation(citation);
        }
        String providerKey = key;
        Map providerMapping = (Map)mapping.get("provider");
        DataProvider provider = new DataProvider(providerKey);
        if (providerMapping != null) {
            provider.setName(MappingUtils.getAsString(providerMapping, "name"));
        } else {
            provider.setName("OBIS");
        }
        dataset.setDataProvider(provider);
        log.trace("[Benchmark] time to retrieve dataset is " + (System.currentTimeMillis() - start));
        return dataset;
    }
}

