/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.gcube.data.spd.model.Properties;
import org.gcube.data.spd.model.Property;
import org.gcube.data.spd.model.TaxonomyItem;
import org.gcube.data.spd.model.exceptions.IdNotValidException;
import org.gcube.data.spd.obisplugin.ObisClient;
import org.gcube.data.spd.obisplugin.PluginSession;
import org.gcube.data.spd.obisplugin.Writer;
import org.gcube.data.spd.obisplugin.pool.PluginSessionPool;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ObisClassification
extends ClassificationCapability {
    protected Logger logger = Logger.getLogger(ObisClassification.class);
    protected PluginSessionPool sessionPool;

    public ObisClassification(PluginSessionPool sessionPool) {
        this.sessionPool = sessionPool;
    }

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    public void searchByCommonName(String word, final ObjectWriter<TaxonomyItem> writer, Property ... properties) {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            try {
                ObisClient.getTaxonByCommonName(session, word, new Writer<TaxonomyItem>(){

                    @Override
                    public boolean write(TaxonomyItem item) {
                        writer.write((Object)item);
                        return writer.isAlive();
                    }
                });
            }
            catch (Exception e) {
                this.logger.error((Object)"Error retrieving taxon", (Throwable)e);
                writer.close();
                this.sessionPool.checkIn(session);
            }
        }
        finally {
            writer.close();
            this.sessionPool.checkIn(session);
        }
    }

    public void searchByScientificName(String word, final ObjectWriter<TaxonomyItem> writer, Property ... properties) {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            try {
                ObisClient.getTaxonByScientificNames(session, word, new Writer<TaxonomyItem>(){

                    @Override
                    public boolean write(TaxonomyItem item) {
                        writer.write((Object)item);
                        return writer.isAlive();
                    }
                });
            }
            catch (Exception e) {
                this.logger.error((Object)("Error retrieving taxon with word \"" + word + "\""), (Throwable)e);
                writer.close();
                this.sessionPool.checkIn(session);
            }
        }
        finally {
            writer.close();
            this.sessionPool.checkIn(session);
        }
    }

    public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String taxonId) throws IdNotValidException {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            int id = this.converId(taxonId);
            List<TaxonomyItem> list = ObisClient.getChildrenTaxon(session, id);
            return list;
        }
        catch (SQLException e) {
            this.logger.error((Object)"Error retrieving TaxonChildsByTaxonId", (Throwable)e);
            return null;
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void retrieveTaxonByIds(Iterator<String> reader, ObjectWriter<TaxonomyItem> writer) {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            block8: {
                block7: {
                    if (!true) break block7;
                    if (!reader.hasNext()) return;
                    if (!writer.isAlive()) break block8;
                }
                do {
                    try {
                        String taxonId = reader.next();
                        int id = this.converId(taxonId);
                        TaxonomyItem item = ObisClient.getTaxonById(session, id);
                        writer.write((Object)item);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Error retrieving TaxonById", (Throwable)e);
                    }
                    if (!reader.hasNext()) return;
                } while (writer.isAlive());
            }
            return;
        }
        finally {
            this.sessionPool.checkIn(session);
            writer.close();
        }
    }

    public TaxonomyItem retrieveTaxonById(String taxonId) throws IdNotValidException {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        int id = this.converId(taxonId);
        try {
            TaxonomyItem item;
            TaxonomyItem taxonomyItem = item = ObisClient.getTaxonById(session, id);
            return taxonomyItem;
        }
        catch (IdNotValidException inve) {
            this.logger.error((Object)"Error retrieving TaxonById", (Throwable)inve);
            throw inve;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error retrieving TaxonById", (Throwable)e);
            return null;
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    protected int converId(String taxonId) throws IdNotValidException {
        try {
            return Integer.parseInt(taxonId);
        }
        catch (NumberFormatException nfe) {
            this.logger.error((Object)("Invalid id " + taxonId), (Throwable)nfe);
            throw new IdNotValidException();
        }
    }
}

