/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;
import org.gcube.data.spd.model.Properties;
import org.gcube.data.spd.obisplugin.ObisClient;
import org.gcube.data.spd.obisplugin.PluginSession;
import org.gcube.data.spd.obisplugin.pool.PluginSessionPool;
import org.gcube.data.spd.plugin.fwk.capabilities.NamesMappingCapability;

public class ObisNameMapping
implements NamesMappingCapability {
    protected Logger logger = Logger.getLogger(ObisNameMapping.class);
    protected PluginSessionPool sessionPool;

    public ObisNameMapping(PluginSessionPool sessionPool) {
        this.sessionPool = sessionPool;
    }

    public Set<String> scientificNameToCommonNamesMapping(String scientificName) {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            Set<String> set = ObisClient.getCommonNames(session, scientificName);
            return set;
        }
        catch (SQLException e) {
            this.logger.error((Object)("An error occurred retrieving the mapping for scientific name " + scientificName), (Throwable)e);
            return null;
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    public Set<String> commonNameToScientificNamesMapping(String commonName) {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            Set<String> set = ObisClient.getScientificNames(session, commonName);
            return set;
        }
        catch (SQLException e) {
            this.logger.error((Object)("An error occurred retrieving the mapping for common name " + commonName), (Throwable)e);
            return null;
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }
}

