/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.gcube.data.spd.obisplugin.data.SearchFilters;
import org.gcube.data.spd.obisplugin.pool.DatabaseCredential;

public class PluginSession {
    protected static final String SCHEMA = "obis";
    protected DatabaseCredential databaseCredential;
    protected Connection connection;
    protected PreparedStatement taxonPreparedStatement;
    protected PreparedStatement taxonCommonNamePreparedStatement;
    protected PreparedStatement datasetPreparedStatement;
    protected PreparedStatement commonNameFromScientificNamePreparedStatement;
    protected PreparedStatement scientificNameFromCommonNamePreparedStatement;
    protected PreparedStatement searchCommonNamePreparedStatement;
    protected PreparedStatement searchScientificNamePreparedStatement;
    protected PreparedStatement scientificNamePreparedStatement;
    protected PreparedStatement commonNamePreparedStatement;
    protected PreparedStatement childrenTaxonPreparedStatement;
    protected PreparedStatement occurrenceByIdPreparedStatement;

    public PluginSession(Connection connection) {
        this(null, connection);
    }

    public PluginSession(DatabaseCredential databaseCredential, Connection connection) {
        this.databaseCredential = databaseCredential;
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isValid(DatabaseCredential databaseCredential) throws SQLException {
        return (this.databaseCredential == null || this.databaseCredential.equals(databaseCredential)) && !this.connection.isClosed() && this.isValid();
    }

    protected boolean isValid() {
        try {
            ResultSet result = this.connection.createStatement().executeQuery("SELECT 1");
            result.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void expire() throws SQLException {
        this.connection.close();
    }

    public void preCacheStatements() throws SQLException {
        this.createTaxonPreparedStatement();
        this.createTaxonCommonNamePreparedStatemen();
        this.createDatasetPreparedStatement();
        this.createCommonNameFromScientificNamePreparedStatement();
        this.createScientificNameFromCommonNamePreparedStatement();
        this.createSearchCommonNamePreparedStatement();
        this.createSearchScientificNamePreparedStatement();
        this.createScientificNamePreparedStatement();
        this.createCommonNamePreparedStatement();
        this.createChildrenTaxonPreparedStatement();
        this.createOccurrenceByIdPreparedStatement();
    }

    public PreparedStatement getTaxonPreparedStatement(int id) throws SQLException {
        if (this.taxonPreparedStatement == null) {
            this.createTaxonPreparedStatement();
        }
        this.taxonPreparedStatement.clearParameters();
        this.taxonPreparedStatement.setInt(1, id);
        return this.taxonPreparedStatement;
    }

    protected void createTaxonPreparedStatement() throws SQLException {
        this.taxonPreparedStatement = this.connection.prepareStatement("SELECT t.tname, t.id, t.parent_id, t.tauthor, t.worms_id, t.col_id, t.irmng_id, t.itis_id, r.rank_name FROM obis.tnames t LEFT JOIN obis.ranks r ON t.rank_id = r.rank_id and r.kingdom_id = CASE WHEN t.rank_id = 10 THEN 738303 ELSE (string_to_array(storedpath, 'x')::text[])[3]::int END WHERE t.id = ?");
    }

    public PreparedStatement getTaxonCommonNamePreparedStatement(int taxonNameId) throws SQLException {
        if (this.taxonCommonNamePreparedStatement == null) {
            this.createTaxonCommonNamePreparedStatemen();
        }
        this.taxonCommonNamePreparedStatement.clearParameters();
        this.taxonCommonNamePreparedStatement.setInt(1, taxonNameId);
        return this.taxonCommonNamePreparedStatement;
    }

    protected void createTaxonCommonNamePreparedStatemen() throws SQLException {
        this.taxonCommonNamePreparedStatement = this.connection.prepareStatement("select c.cname, l.lanname FROM obis.cnames c, obis.languages l WHERE c.tname_id = ? AND c.language_id = l.id");
    }

    public PreparedStatement getDatasetPreparedStatement(int id) throws SQLException {
        if (this.datasetPreparedStatement == null) {
            this.createDatasetPreparedStatement();
        }
        this.datasetPreparedStatement.clearParameters();
        this.datasetPreparedStatement.setInt(1, id);
        return this.datasetPreparedStatement;
    }

    protected void createDatasetPreparedStatement() throws SQLException {
        String query = "SELECT r.id as datasetId, r.resname as datasetName, r.citation as datasetCitation, p.id as providerId, p.providername as providerName FROM obis.resources r, obis.providers p WHERE exists (SELECT r.id FROM obis.drs d WHERE d.valid_id = ? AND d.resource_id = r.id) AND r.provider_id = p.id";
        this.datasetPreparedStatement = this.connection.prepareStatement(query);
    }

    public PreparedStatement getCommonNameFromScientificNamePreparedStatement(String scientificaName) throws SQLException {
        if (this.commonNameFromScientificNamePreparedStatement == null) {
            this.createCommonNameFromScientificNamePreparedStatement();
        }
        this.commonNameFromScientificNamePreparedStatement.clearParameters();
        this.commonNameFromScientificNamePreparedStatement.setString(1, scientificaName);
        return this.commonNameFromScientificNamePreparedStatement;
    }

    protected void createCommonNameFromScientificNamePreparedStatement() throws SQLException {
        this.commonNameFromScientificNamePreparedStatement = this.connection.prepareStatement("SELECT c.cname FROM obis.cnames c, obis.tnames t WHERE t.tname ILIKE ? AND c.tname_id = t.id");
    }

    public PreparedStatement getScientificNameFromCommonNamePreparedStatement(String commonName) throws SQLException {
        if (this.scientificNameFromCommonNamePreparedStatement == null) {
            this.createScientificNameFromCommonNamePreparedStatement();
        }
        this.scientificNameFromCommonNamePreparedStatement.clearParameters();
        this.scientificNameFromCommonNamePreparedStatement.setString(1, commonName);
        return this.scientificNameFromCommonNamePreparedStatement;
    }

    protected void createScientificNameFromCommonNamePreparedStatement() throws SQLException {
        this.scientificNameFromCommonNamePreparedStatement = this.connection.prepareStatement("SELECT DISTINCT t.tname FROM obis.cnames c, obis.tnames t WHERE c.cname ILIKE ? AND c.tname_id = t.id");
    }

    public PreparedStatement getSearchCommonNamePreparedStatement(String searchTerm) throws SQLException {
        if (this.searchCommonNamePreparedStatement == null) {
            this.createSearchCommonNamePreparedStatement();
        }
        this.searchCommonNamePreparedStatement.clearParameters();
        this.searchCommonNamePreparedStatement.setString(1, "%" + searchTerm + "%");
        return this.searchCommonNamePreparedStatement;
    }

    protected void createSearchCommonNamePreparedStatement() throws SQLException {
        String query = "SELECT DISTINCT c.tname_id AS id FROM obis.cnames c WHERE c.cname ILIKE ?";
        this.searchCommonNamePreparedStatement = this.connection.prepareStatement(query);
    }

    public PreparedStatement getSearchScientificNamePreparedStatement(String searchTerm) throws SQLException {
        if (this.searchScientificNamePreparedStatement == null) {
            this.createSearchScientificNamePreparedStatement();
        }
        this.searchScientificNamePreparedStatement.clearParameters();
        this.searchScientificNamePreparedStatement.setString(1, "%" + searchTerm + "%");
        return this.searchScientificNamePreparedStatement;
    }

    protected void createSearchScientificNamePreparedStatement() throws SQLException {
        String query = "SELECT t.id as id FROM obis.tnames t WHERE t.tname ILIKE ? AND exists (SELECT 1 FROM obis.drs WHERE valid_id = t.id)";
        this.searchScientificNamePreparedStatement = this.connection.prepareStatement(query);
    }

    public PreparedStatement getOccurrencesCountPreparedStatement(int taxonId, int datasetId, SearchFilters filters) throws SQLException {
        StringBuilder query = new StringBuilder("SELECT count(*) AS occurrences FROM obis.drs WHERE valid_id = ? AND resource_id = ?");
        if (filters.getUpperBound() != null) {
            query.append(" AND latitude <= ? AND longitude <= ?");
        }
        if (filters.getLowerBound() != null) {
            query.append(" AND latitude >= ? AND longitude >= ?");
        }
        if (filters.getFromDate() != null) {
            query.append(" AND datecollected >= ?");
        }
        if (filters.getToDate() != null) {
            query.append(" AND datecollected <= ?");
        }
        PreparedStatement occurrencesCountPreparedStatement = this.connection.prepareStatement(query.toString());
        int parameterCounter = 1;
        occurrencesCountPreparedStatement.setInt(parameterCounter++, taxonId);
        occurrencesCountPreparedStatement.setInt(parameterCounter++, datasetId);
        if (filters.getUpperBound() != null) {
            occurrencesCountPreparedStatement.setDouble(parameterCounter++, filters.getUpperBound().getLatitude());
            occurrencesCountPreparedStatement.setDouble(parameterCounter++, filters.getUpperBound().getLongitude());
        }
        if (filters.getLowerBound() != null) {
            occurrencesCountPreparedStatement.setDouble(parameterCounter++, filters.getLowerBound().getLatitude());
            occurrencesCountPreparedStatement.setDouble(parameterCounter++, filters.getLowerBound().getLongitude());
        }
        if (filters.getFromDate() != null) {
            occurrencesCountPreparedStatement.setDate(parameterCounter++, new Date(filters.getFromDate().getTimeInMillis()));
        }
        if (filters.getToDate() != null) {
            occurrencesCountPreparedStatement.setDate(parameterCounter++, new Date(filters.getToDate().getTimeInMillis()));
        }
        return occurrencesCountPreparedStatement;
    }

    protected PreparedStatement getOccurrencesPreparedStatement(int taxonId, int datasetId, SearchFilters filters) throws SQLException {
        StringBuilder query = new StringBuilder("SELECT drs.id, drs.latitude, drs.longitude, drs.datecollected, drs.basisofrecord, dxs.citation, dxs.institutioncode, dxs.collectioncode, dxs.catalognumber, dxs.collector, dxs.datelastmodified, dxs.country, dxs.locality, dxs.minimumdepth, dxs.maximumdepth, dxs.coordinateprecision, dxs.concatenated FROM obis.drs drs, obis.dxs dxs WHERE drs.valid_id = ? AND drs.resource_id = ? AND drs.id = dxs.dr_id");
        if (filters.getUpperBound() != null) {
            query.append(" AND drs.latitude <= ? AND drs.longitude <= ?");
        }
        if (filters.getLowerBound() != null) {
            query.append(" AND drs.latitude >= ? AND drs.longitude >= ?");
        }
        if (filters.getFromDate() != null) {
            query.append(" AND drs.datecollected >= ?");
        }
        if (filters.getToDate() != null) {
            query.append(" AND drs.datecollected <= ?");
        }
        PreparedStatement occurrencesPreparedStatement = this.connection.prepareStatement(query.toString());
        int parameterCounter = 1;
        occurrencesPreparedStatement.setInt(parameterCounter++, taxonId);
        occurrencesPreparedStatement.setInt(parameterCounter++, datasetId);
        if (filters.getUpperBound() != null) {
            occurrencesPreparedStatement.setDouble(parameterCounter++, filters.getUpperBound().getLatitude());
            occurrencesPreparedStatement.setDouble(parameterCounter++, filters.getUpperBound().getLongitude());
        }
        if (filters.getLowerBound() != null) {
            occurrencesPreparedStatement.setDouble(parameterCounter++, filters.getLowerBound().getLatitude());
            occurrencesPreparedStatement.setDouble(parameterCounter++, filters.getLowerBound().getLongitude());
        }
        if (filters.getFromDate() != null) {
            occurrencesPreparedStatement.setDate(parameterCounter++, new Date(filters.getFromDate().getTimeInMillis()));
        }
        if (filters.getToDate() != null) {
            occurrencesPreparedStatement.setDate(parameterCounter++, new Date(filters.getToDate().getTimeInMillis()));
        }
        return occurrencesPreparedStatement;
    }

    public PreparedStatement getScientificNamePreparedStatement(String scientificName) throws SQLException {
        if (this.scientificNamePreparedStatement == null) {
            this.createScientificNamePreparedStatement();
        }
        this.scientificNamePreparedStatement.clearParameters();
        this.scientificNamePreparedStatement.setString(1, "%" + scientificName + "%");
        return this.scientificNamePreparedStatement;
    }

    protected void createScientificNamePreparedStatement() throws SQLException {
        String query = "SELECT t.id as id FROM obis.tnames t WHERE t.tname ILIKE ?";
        this.scientificNamePreparedStatement = this.connection.prepareStatement(query);
    }

    public PreparedStatement getCommonNamePreparedStatement(String commonName) throws SQLException {
        if (this.commonNamePreparedStatement == null) {
            this.createCommonNamePreparedStatement();
        }
        this.commonNamePreparedStatement.clearParameters();
        this.commonNamePreparedStatement.setString(1, commonName);
        return this.commonNamePreparedStatement;
    }

    protected void createCommonNamePreparedStatement() throws SQLException {
        this.commonNamePreparedStatement = this.connection.prepareStatement("SELECT c.tname_id as id FROM obis.cnames c WHERE c.cname LIKE ?");
    }

    public PreparedStatement getChildrenTaxonPreparedStatement(int id) throws SQLException {
        if (this.childrenTaxonPreparedStatement == null) {
            this.createChildrenTaxonPreparedStatement();
        }
        this.childrenTaxonPreparedStatement.clearParameters();
        this.childrenTaxonPreparedStatement.setInt(1, id);
        return this.childrenTaxonPreparedStatement;
    }

    protected void createChildrenTaxonPreparedStatement() throws SQLException {
        this.childrenTaxonPreparedStatement = this.connection.prepareStatement("SELECT t.tname, t.id as id, t.parent_id, t.tauthor, r.rank_name FROM obis.tnames t LEFT JOIN obis.ranks r ON t.rank_id = r.rank_id and r.kingdom_id = CASE WHEN t.rank_id = 10 THEN 738303 ELSE (string_to_array(storedpath, 'x')::text[])[3]::int END WHERE t.parent_id = ?");
    }

    protected PreparedStatement getOccurrenceByIdPreparedStatement(int occurrenceId) throws SQLException {
        if (this.occurrenceByIdPreparedStatement == null) {
            this.createOccurrenceByIdPreparedStatement();
        }
        this.occurrenceByIdPreparedStatement.clearParameters();
        this.occurrenceByIdPreparedStatement.setInt(1, occurrenceId);
        return this.occurrenceByIdPreparedStatement;
    }

    protected void createOccurrenceByIdPreparedStatement() throws SQLException {
        String query = "SELECT drs.id, drs.latitude, drs.longitude, drs.datecollected, drs.basisofrecord, dxs.citation, dxs.institutioncode, dxs.collectioncode, dxs.catalognumber, dxs.collector, dxs.datelastmodified, dxs.country, dxs.locality, dxs.minimumdepth, dxs.maximumdepth, dxs.coordinateprecision, dxs.concatenated FROM obis.drs drs, obis.dxs dxs WHERE drs.id = ? AND drs.id = dxs.dr_id";
        this.occurrenceByIdPreparedStatement = this.connection.prepareStatement(query);
    }
}

