/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.pool;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.gcube.data.spd.obisplugin.pool.ObjectPool;

public class JDBCConnectionPool
extends ObjectPool<Connection> {
    protected String url;
    protected String username;
    protected String password;

    public JDBCConnectionPool(String driver, String dsn, String usr, String pwd) {
        super(600000L);
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.url = dsn;
        this.username = usr;
        this.password = pwd;
    }

    @Override
    protected Connection create() {
        try {
            return DriverManager.getConnection(this.url, this.username, this.password);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void expire(Connection o) {
        try {
            o.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean validate(Connection o) {
        try {
            return !o.isClosed() && o.isValid(1000);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }
}

